/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class SecantSolver
extends AbstractUnivariateSolver {
    protected static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public SecantSolver() {
        super(1.0E-6);
    }

    public SecantSolver(double d2) {
        super(d2);
    }

    public SecantSolver(double d2, double d3) {
        super(d2, d3);
    }

    protected final double doSolve() {
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = this.computeObjectiveValue(d2);
        double d5 = this.computeObjectiveValue(d3);
        if (d4 == 0.0) {
            return d2;
        }
        if (d5 == 0.0) {
            return d3;
        }
        this.verifyBracketing(d2, d3);
        double d6 = this.getFunctionValueAccuracy();
        double d7 = this.getAbsoluteAccuracy();
        double d8 = this.getRelativeAccuracy();
        do {
            double d9;
            double d10;
            double d11;
            if ((d11 = this.computeObjectiveValue(d10 = d3 - d5 * (d3 - d2) / (d5 - d4))) == 0.0) {
                return d10;
            }
            d2 = d3;
            d4 = d5;
            d3 = d10;
            d5 = d11;
            if (!(FastMath.abs(d9) <= d6)) continue;
            return d3;
        } while (!(FastMath.abs(d3 - d2) < FastMath.max(d8 * FastMath.abs(d3), d7)));
        return d3;
    }
}

