/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class RiddersSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public RiddersSolver() {
        this(1.0E-6);
    }

    public RiddersSolver(double d2) {
        super(d2);
    }

    public RiddersSolver(double d2, double d3) {
        super(d2, d3);
    }

    protected double doSolve() {
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = d2;
        double d5 = this.computeObjectiveValue(d4);
        double d6 = d3;
        double d7 = this.computeObjectiveValue(d6);
        if (d5 == 0.0) {
            return d2;
        }
        if (d7 == 0.0) {
            return d3;
        }
        this.verifyBracketing(d2, d3);
        double d8 = this.getAbsoluteAccuracy();
        double d9 = this.getFunctionValueAccuracy();
        double d10 = this.getRelativeAccuracy();
        double d11 = Double.POSITIVE_INFINITY;
        while (true) {
            double d12;
            double d13 = 0.5 * (d4 + d6);
            double d14 = this.computeObjectiveValue(d13);
            if (FastMath.abs(d12) <= d9) {
                return d13;
            }
            double d15 = d14;
            double d16 = 1.0 - d5 * d7 / (d15 * d15);
            double d17 = FastMath.signum(d7) * FastMath.signum(d14) * (d13 - d4) / FastMath.sqrt(d16);
            double d18 = d13 - d17;
            double d19 = this.computeObjectiveValue(d18);
            double d20 = FastMath.max(d10 * FastMath.abs(d18), d8);
            if (FastMath.abs(d18 - d11) <= d20) {
                return d18;
            }
            if (FastMath.abs(d19) <= d9) {
                return d18;
            }
            if (d17 > 0.0) {
                if (FastMath.signum(d5) + FastMath.signum(d19) == 0.0) {
                    d6 = d18;
                    d7 = d19;
                } else {
                    d4 = d18;
                    d6 = d13;
                    d5 = d19;
                    d7 = d14;
                }
            } else if (FastMath.signum(d7) + FastMath.signum(d19) == 0.0) {
                d4 = d18;
                d5 = d19;
            } else {
                d4 = d13;
                d6 = d18;
                d5 = d14;
                d7 = d19;
            }
            d11 = d18;
        }
    }
}

