/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateDifferentiableSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class NewtonRaphsonSolver
extends AbstractUnivariateDifferentiableSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public NewtonRaphsonSolver() {
        this(1.0E-6);
    }

    public NewtonRaphsonSolver(double d2) {
        super(d2);
    }

    public double solve(int n, UnivariateDifferentiableFunction univariateDifferentiableFunction, double d2, double d3) {
        return super.solve(n, univariateDifferentiableFunction, UnivariateSolverUtils.midpoint(d2, d3));
    }

    protected double doSolve() {
        double d2 = this.getStartValue();
        double d3 = this.getAbsoluteAccuracy();
        double d4 = d2;
        while (true) {
            double d5;
            DerivativeStructure derivativeStructure = this.computeObjectiveValueAndDerivative(d4);
            double d6 = d4 - derivativeStructure.getValue() / derivativeStructure.getPartialDerivative(1);
            if (FastMath.abs(d5 - d4) <= d3) {
                return d6;
            }
            d4 = d6;
        }
    }
}

