/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoBracketingException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class MullerSolver2
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public MullerSolver2() {
        this(1.0E-6);
    }

    public MullerSolver2(double d2) {
        super(d2);
    }

    public MullerSolver2(double d2, double d3) {
        super(d2, d3);
    }

    protected double doSolve() {
        double d2;
        double d3;
        double d4 = this.getMin();
        double d5 = this.getMax();
        this.verifyInterval(d4, d5);
        double d6 = this.getRelativeAccuracy();
        double d7 = this.getAbsoluteAccuracy();
        double d8 = this.getFunctionValueAccuracy();
        double d9 = d4;
        double d10 = this.computeObjectiveValue(d9);
        if (FastMath.abs(d3) < d8) {
            return d9;
        }
        double d11 = d5;
        double d12 = this.computeObjectiveValue(d11);
        if (FastMath.abs(d2) < d8) {
            return d11;
        }
        if (d10 * d12 > 0.0) {
            throw new NoBracketingException(d9, d11, d10, d12);
        }
        double d13 = 0.5 * (d9 + d11);
        double d14 = this.computeObjectiveValue(d13);
        double d15 = Double.POSITIVE_INFINITY;
        while (true) {
            double d16;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21 = (d13 - d11) / (d11 - d9);
            double d22 = d21 * (d14 - (d21 + 1.0) * d12 + d21 * d10);
            double d23 = d21;
            double d24 = (d21 * 2.0 + 1.0) * d14 - (d21 + 1.0) * (d21 + 1.0) * d12 + d23 * d23 * d10;
            double d25 = (d21 + 1.0) * d14;
            double d26 = d24;
            double d27 = d26 * d26 - d22 * 4.0 * d25;
            if (d20 >= 0.0) {
                d19 = d24 + FastMath.sqrt(d27);
                d18 = d24 - FastMath.sqrt(d27);
                d17 = FastMath.abs(d19) > FastMath.abs(d18) ? d19 : d18;
            } else {
                double d28 = d24;
                d17 = FastMath.sqrt(d28 * d28 - d27);
            }
            if (d17 != 0.0) {
                for (d16 = d13 - d25 * 2.0 * (d13 - d11) / d17; d16 == d11 || d16 == d13; d16 += d7) {
                }
            } else {
                d16 = d4 + FastMath.random() * (d5 - d4);
                d15 = Double.POSITIVE_INFINITY;
            }
            d19 = this.computeObjectiveValue(d16);
            d18 = FastMath.max(d6 * FastMath.abs(d16), d7);
            if (FastMath.abs(d16 - d15) <= d18 || FastMath.abs(d19) <= d8) {
                return d16;
            }
            d9 = d11;
            d10 = d12;
            d11 = d13;
            d12 = d14;
            d13 = d16;
            d14 = d19;
            d15 = d16;
        }
    }
}

