/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class MullerSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public MullerSolver() {
        this(1.0E-6);
    }

    public MullerSolver(double d2) {
        super(d2);
    }

    public MullerSolver(double d2, double d3) {
        super(d2, d3);
    }

    protected double doSolve() {
        double d2;
        double d3;
        double d4;
        double d5 = this.getMin();
        double d6 = this.getMax();
        double d7 = this.getStartValue();
        double d8 = this.getFunctionValueAccuracy();
        this.verifySequence(d5, d7, d6);
        double d9 = this.computeObjectiveValue(d5);
        if (FastMath.abs(d4) < d8) {
            return d5;
        }
        double d10 = this.computeObjectiveValue(d6);
        if (FastMath.abs(d3) < d8) {
            return d6;
        }
        double d11 = this.computeObjectiveValue(d7);
        if (FastMath.abs(d2) < d8) {
            return d7;
        }
        this.verifyBracketing(d5, d6);
        if (this.isBracketing(d5, d7)) {
            return this.solve(d5, d7, d9, d11);
        }
        return this.solve(d7, d6, d11, d10);
    }

    private double solve(double d2, double d3, double d4, double d5) {
        double d6 = this.getRelativeAccuracy();
        double d7 = this.getAbsoluteAccuracy();
        double d8 = this.getFunctionValueAccuracy();
        double d9 = d2;
        double d10 = d4;
        double d11 = d3;
        double d12 = d5;
        double d13 = 0.5 * (d9 + d11);
        double d14 = this.computeObjectiveValue(d13);
        double d15 = Double.POSITIVE_INFINITY;
        while (true) {
            double d16 = (d14 - d10) / (d13 - d9);
            double d17 = (d12 - d14) / (d11 - d13);
            double d18 = (d17 - d16) / (d11 - d9);
            double d19 = d16 + (d13 - d9) * d18;
            double d20 = d19 * d19 - d14 * 4.0 * d18;
            double d21 = d13 + d14 * -2.0 / (d19 + FastMath.sqrt(d20));
            double d22 = d13 + d14 * -2.0 / (d19 - FastMath.sqrt(d20));
            double d23 = this.isSequence(d9, d21, d11) ? d21 : d22;
            double d24 = this.computeObjectiveValue(d23);
            double d25 = FastMath.max(d6 * FastMath.abs(d23), d7);
            if (FastMath.abs(d23 - d15) <= d25 || FastMath.abs(d24) <= d8) {
                return d23;
            }
            boolean bl = d23 < d13 && d13 - d9 > 0.95 * (d11 - d9) || d23 > d13 && d11 - d13 > 0.95 * (d11 - d9) || d23 == d13;
            if (!bl) {
                d9 = d23 < d13 ? d9 : d13;
                d10 = d23 < d13 ? d10 : d14;
                d11 = d23 > d13 ? d11 : d13;
                d12 = d23 > d13 ? d12 : d14;
                d13 = d23;
                d14 = d24;
                d15 = d23;
                continue;
            }
            double d26 = 0.5 * (d9 + d11);
            double d27 = this.computeObjectiveValue(d26);
            if (FastMath.signum(d10) + FastMath.signum(d27) == 0.0) {
                d11 = d26;
                d12 = d27;
            } else {
                d9 = d26;
                d10 = d27;
            }
            d13 = 0.5 * (d9 + d11);
            d14 = this.computeObjectiveValue(d13);
            d15 = Double.POSITIVE_INFINITY;
        }
    }
}

