/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractPolynomialSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.LaguerreSolver$ComplexSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.ComplexUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoBracketingException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class LaguerreSolver
extends AbstractPolynomialSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private final LaguerreSolver$ComplexSolver complexSolver = new LaguerreSolver$ComplexSolver(this, null);

    public LaguerreSolver() {
        this(1.0E-6);
    }

    public LaguerreSolver(double d2) {
        super(d2);
    }

    public LaguerreSolver(double d2, double d3) {
        super(d2, d3);
    }

    public LaguerreSolver(double d2, double d3, double d4) {
        super(d2, d3, d4);
    }

    public double doSolve() {
        double d2;
        double d3;
        double d4;
        double d5 = this.getMin();
        double d6 = this.getMax();
        double d7 = this.getStartValue();
        double d8 = this.getFunctionValueAccuracy();
        this.verifySequence(d5, d7, d6);
        double d9 = this.computeObjectiveValue(d7);
        if (FastMath.abs(d4) <= d8) {
            return d7;
        }
        double d10 = this.computeObjectiveValue(d5);
        if (FastMath.abs(d3) <= d8) {
            return d5;
        }
        if (d9 * d10 < 0.0) {
            return this.laguerre(d5, d7, d10, d9);
        }
        double d11 = this.computeObjectiveValue(d6);
        if (FastMath.abs(d2) <= d8) {
            return d6;
        }
        if (d9 * d11 < 0.0) {
            return this.laguerre(d7, d6, d9, d11);
        }
        throw new NoBracketingException(d5, d6, d10, d11);
    }

    @Deprecated
    public double laguerre(double d2, double d3, double d4, double d5) {
        Complex complex;
        Complex[] complexArray = ComplexUtils.convertToComplex(this.getCoefficients());
        Complex complex2 = this.complexSolver.solve(complexArray, complex = new Complex(0.5 * (d2 + d3), 0.0));
        if (this.complexSolver.isRoot(d2, d3, complex2)) {
            return complex2.getReal();
        }
        double d6 = Double.NaN;
        complexArray = this.complexSolver.solveAll(complexArray, complex);
        for (int i2 = 0; i2 < complexArray.length; ++i2) {
            if (!this.complexSolver.isRoot(d2, d3, complexArray[i2])) continue;
            d6 = complexArray[i2].getReal();
            break;
        }
        return d6;
    }

    public Complex[] solveAllComplex(double[] dArray, double d2) {
        return this.solveAllComplex(dArray, d2, Integer.MAX_VALUE);
    }

    public Complex[] solveAllComplex(double[] dArray, double d2, int n) {
        this.setup(n, new PolynomialFunction(dArray), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, d2);
        return this.complexSolver.solveAll(ComplexUtils.convertToComplex(dArray), new Complex(d2, 0.0));
    }

    public Complex solveComplex(double[] dArray, double d2) {
        return this.solveComplex(dArray, d2, Integer.MAX_VALUE);
    }

    public Complex solveComplex(double[] dArray, double d2, int n) {
        this.setup(n, new PolynomialFunction(dArray), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, d2);
        return this.complexSolver.solve(ComplexUtils.convertToComplex(dArray), new Complex(d2, 0.0));
    }
}

