/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.LaguerreSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.LaguerreSolver$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.complex.Complex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

class LaguerreSolver$ComplexSolver {
    final /* synthetic */ LaguerreSolver this$0;

    private LaguerreSolver$ComplexSolver(LaguerreSolver laguerreSolver) {
        this.this$0 = laguerreSolver;
    }

    public boolean isRoot(double d2, double d3, Complex complex) {
        if (this.this$0.isSequence(d2, complex.getReal(), d3)) {
            double d4 = FastMath.max(this.this$0.getRelativeAccuracy() * complex.abs(), this.this$0.getAbsoluteAccuracy());
            return FastMath.abs(complex.getImaginary()) <= d4 || complex.abs() <= this.this$0.getFunctionValueAccuracy();
        }
        return false;
    }

    public Complex[] solveAll(Complex[] complexArray, Complex complex) {
        if (complexArray == null) {
            throw new NullArgumentException();
        }
        int n = complexArray.length - 1;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.POLYNOMIAL);
        }
        Complex[] complexArray2 = new Complex[n + 1];
        for (int i2 = 0; i2 <= n; ++i2) {
            complexArray2[i2] = complexArray[i2];
        }
        Complex[] complexArray3 = new Complex[n];
        for (int i3 = 0; i3 < n; ++i3) {
            Object object = new Complex[n - i3 + 1];
            System.arraycopy(complexArray2, 0, object, 0, ((Complex[])object).length);
            complexArray3[i3] = this.solve((Complex[])object, complex);
            object = complexArray2[n - i3];
            for (int i4 = n - i3 - 1; i4 >= 0; --i4) {
                Complex complex2 = complexArray2[i4];
                complexArray2[i4] = object;
                object = complex2.add(((Complex)object).multiply(complexArray3[i3]));
            }
        }
        return complexArray3;
    }

    public Complex solve(Complex[] complexArray, Complex complex) {
        if (complexArray == null) {
            throw new NullArgumentException();
        }
        int n = complexArray.length - 1;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.POLYNOMIAL);
        }
        double d2 = this.this$0.getAbsoluteAccuracy();
        double d3 = this.this$0.getRelativeAccuracy();
        double d4 = this.this$0.getFunctionValueAccuracy();
        Complex complex2 = new Complex(n, 0.0);
        Complex complex3 = new Complex(n - 1, 0.0);
        Complex complex4 = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        while (true) {
            Complex complex5 = complexArray[n];
            Complex complex6 = Complex.ZERO;
            Complex complex7 = Complex.ZERO;
            for (int i2 = n - 1; i2 >= 0; --i2) {
                complex7 = complex6.add(complex.multiply(complex7));
                complex6 = complex5.add(complex.multiply(complex6));
                complex5 = complexArray[i2].add(complex.multiply(complex5));
            }
            complex7 = complex7.multiply(new Complex(2.0, 0.0));
            double d5 = FastMath.max(d3 * complex.abs(), d2);
            if (complex.subtract(complex4).abs() <= d5) {
                return complex;
            }
            if (complex5.abs() <= d4) {
                return complex;
            }
            complex4 = complex6.divide(complex5);
            complex6 = complex4.multiply(complex4);
            complex5 = complex6.subtract(complex7.divide(complex5));
            complex5 = complex3.multiply(complex2.multiply(complex5).subtract(complex6));
            complex5 = complex5.sqrt();
            complex6 = complex4.add(complex5);
            complex4 = complex4.subtract(complex5);
            complex5 = complex6.abs() > complex4.abs() ? complex6 : complex4;
            if (complex5.equals(new Complex(0.0, 0.0))) {
                double d6 = d2;
                complex = complex.add(new Complex(d6, d6));
                complex4 = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            } else {
                complex4 = complex;
                complex = complex.subtract(complex2.divide(complex5));
            }
            this.this$0.incrementEvaluationCount();
        }
    }

    /* synthetic */ LaguerreSolver$ComplexSolver(LaguerreSolver laguerreSolver, LaguerreSolver$1 laguerreSolver$1) {
        this(laguerreSolver);
    }
}

