/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.RealFieldUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AllowedSolution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedRealFieldUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoBracketingException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBracketingNthOrderBrentSolver<T extends RealFieldElement<T>>
implements BracketedRealFieldUnivariateSolver<T> {
    private static final int MAXIMAL_AGING = 2;
    private final Field<T> field;
    private final int maximalOrder;
    private final T functionValueAccuracy;
    private final T absoluteAccuracy;
    private final T relativeAccuracy;
    private IntegerSequence$Incrementor evaluations;

    public FieldBracketingNthOrderBrentSolver(T t, T t2, T t3, int n) {
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.field = t.getField();
        this.maximalOrder = n;
        this.absoluteAccuracy = t2;
        this.relativeAccuracy = t;
        this.functionValueAccuracy = t3;
        this.evaluations = IntegerSequence$Incrementor.create();
    }

    public int getMaximalOrder() {
        return this.maximalOrder;
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public T getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public T getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public T getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    @Override
    public T solve(int n, RealFieldUnivariateFunction<T> realFieldUnivariateFunction, T t, T t2, AllowedSolution allowedSolution) {
        return (T)this.solve(n, realFieldUnivariateFunction, t, t2, (RealFieldElement)((RealFieldElement)t.add(t2)).divide(2.0), allowedSolution);
    }

    @Override
    public T solve(int n, RealFieldUnivariateFunction<T> realFieldUnivariateFunction, T t, T t2, T object, AllowedSolution allowedSolution) {
        int n2;
        int n3;
        MathUtils.checkNotNull(realFieldUnivariateFunction);
        this.evaluations = this.evaluations.withMaximalCount(n).withStart(0);
        RealFieldElement realFieldElement = (RealFieldElement)this.field.getZero();
        RealFieldElement realFieldElement2 = (RealFieldElement)realFieldElement.add(Double.NaN);
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.field, this.maximalOrder + 1);
        RealFieldElement[] realFieldElementArray2 = (RealFieldElement[])MathArrays.buildArray(this.field, this.maximalOrder + 1);
        realFieldElementArray[0] = t;
        realFieldElementArray[1] = object;
        realFieldElementArray[2] = t2;
        this.evaluations.increment();
        realFieldElementArray2[1] = realFieldUnivariateFunction.value(realFieldElementArray[1]);
        if (Precision.equals(realFieldElementArray2[1].getReal(), 0.0, 1)) {
            return (T)realFieldElementArray[1];
        }
        this.evaluations.increment();
        realFieldElementArray2[0] = realFieldUnivariateFunction.value(realFieldElementArray[0]);
        if (Precision.equals(realFieldElementArray2[0].getReal(), 0.0, 1)) {
            return (T)realFieldElementArray[0];
        }
        if (realFieldElementArray2[0].multiply(realFieldElementArray2[1]).getReal() < 0.0) {
            n3 = 2;
            n2 = 1;
        } else {
            this.evaluations.increment();
            realFieldElementArray2[2] = realFieldUnivariateFunction.value(realFieldElementArray[2]);
            if (Precision.equals(realFieldElementArray2[2].getReal(), 0.0, 1)) {
                return (T)realFieldElementArray[2];
            }
            if (realFieldElementArray2[1].multiply(realFieldElementArray2[2]).getReal() < 0.0) {
                n3 = 3;
                n2 = 2;
            } else {
                throw new NoBracketingException(realFieldElementArray[0].getReal(), realFieldElementArray[2].getReal(), realFieldElementArray2[0].getReal(), realFieldElementArray2[2].getReal());
            }
        }
        object = (RealFieldElement[])MathArrays.buildArray(this.field, realFieldElementArray.length);
        RealFieldElement realFieldElement3 = realFieldElementArray[n2 - 1];
        RealFieldElement realFieldElement4 = realFieldElementArray2[n2 - 1];
        RealFieldElement realFieldElement5 = (RealFieldElement)realFieldElement3.abs();
        RealFieldElement realFieldElement6 = (RealFieldElement)realFieldElement4.abs();
        int n4 = 0;
        RealFieldElement realFieldElement7 = realFieldElementArray[n2];
        RealFieldElement realFieldElement8 = realFieldElementArray2[n2];
        RealFieldElement realFieldElement9 = (RealFieldElement)realFieldElement7.abs();
        RealFieldElement realFieldElement10 = (RealFieldElement)realFieldElement8.abs();
        int n5 = 0;
        while (true) {
            RealFieldElement realFieldElement11 = realFieldElement5.subtract(realFieldElement9).getReal() < 0.0 ? realFieldElement9 : realFieldElement5;
            RealFieldElement realFieldElement12 = realFieldElement6.subtract(realFieldElement10).getReal() < 0.0 ? realFieldElement10 : realFieldElement6;
            realFieldElement11 = this.absoluteAccuracy.add((RealFieldElement)this.relativeAccuracy.multiply((RealFieldElement)realFieldElement11));
            if (realFieldElement7.subtract(realFieldElement3).subtract(realFieldElement11).getReal() <= 0.0 || ((RealFieldElement)realFieldElement12.subtract(this.functionValueAccuracy)).getReal() < 0.0) {
                switch (allowedSolution) {
                    case ANY_SIDE: {
                        if (realFieldElement6.subtract(realFieldElement10).getReal() < 0.0) {
                            return (T)realFieldElement3;
                        }
                        return (T)realFieldElement7;
                    }
                    case LEFT_SIDE: {
                        return (T)realFieldElement3;
                    }
                    case RIGHT_SIDE: {
                        return (T)realFieldElement7;
                    }
                    case BELOW_SIDE: {
                        if (realFieldElement4.getReal() <= 0.0) {
                            return (T)realFieldElement3;
                        }
                        return (T)realFieldElement7;
                    }
                    case ABOVE_SIDE: {
                        if (realFieldElement4.getReal() < 0.0) {
                            return (T)realFieldElement7;
                        }
                        return (T)realFieldElement3;
                    }
                }
                throw new MathInternalError(null);
            }
            realFieldElement11 = n4 >= 2 ? (RealFieldElement)((RealFieldElement)realFieldElement8.divide(16.0)).negate() : (n5 >= 2 ? (RealFieldElement)((RealFieldElement)realFieldElement4.divide(16.0)).negate() : realFieldElement);
            int n6 = 0;
            int n7 = n3;
            do {
                RealFieldElement realFieldElement13;
                System.arraycopy(realFieldElementArray, n6, object, n6, n7 - n6);
                realFieldElement12 = this.guessX(realFieldElement11, (RealFieldElement[])object, realFieldElementArray2, n6, n7);
                if (realFieldElement13.subtract(realFieldElement3).getReal() > 0.0 && realFieldElement12.subtract(realFieldElement7).getReal() < 0.0) continue;
                if (n2 - n6 >= n7 - n2) {
                    ++n6;
                } else {
                    --n7;
                }
                realFieldElement12 = realFieldElement2;
            } while (Double.isNaN(realFieldElement12.getReal()) && n7 - n6 > 1);
            if (Double.isNaN(realFieldElement12.getReal())) {
                realFieldElement12 = (RealFieldElement)realFieldElement3.add(realFieldElement7.subtract(realFieldElement3).divide(2.0));
                n6 = n2 - 1;
                n7 = n2;
            }
            this.evaluations.increment();
            realFieldElement11 = realFieldUnivariateFunction.value(realFieldElement12);
            if (Precision.equals(realFieldElement11.getReal(), 0.0, 1)) {
                return (T)realFieldElement12;
            }
            if (n3 > 2 && n7 - n6 != n3) {
                n3 = n7 - n6;
                System.arraycopy(realFieldElementArray, n6, realFieldElementArray, 0, n3);
                System.arraycopy(realFieldElementArray2, n6, realFieldElementArray2, 0, n3);
                n2 -= n6;
            } else if (n3 == realFieldElementArray.length) {
                --n3;
                if (n2 >= (realFieldElementArray.length + 1) / 2) {
                    System.arraycopy(realFieldElementArray, 1, realFieldElementArray, 0, n3);
                    System.arraycopy(realFieldElementArray2, 1, realFieldElementArray2, 0, n3);
                    --n2;
                }
            }
            System.arraycopy(realFieldElementArray, n2, realFieldElementArray, n2 + 1, n3 - n2);
            realFieldElementArray[n2] = realFieldElement12;
            System.arraycopy(realFieldElementArray2, n2, realFieldElementArray2, n2 + 1, n3 - n2);
            realFieldElementArray2[n2] = realFieldElement11;
            ++n3;
            if (realFieldElement11.multiply(realFieldElement4).getReal() <= 0.0) {
                realFieldElement7 = realFieldElement12;
                realFieldElement8 = realFieldElement11;
                realFieldElement10 = (RealFieldElement)realFieldElement8.abs();
                ++n4;
                n5 = 0;
                continue;
            }
            realFieldElement3 = realFieldElement12;
            realFieldElement4 = realFieldElement11;
            realFieldElement6 = (RealFieldElement)realFieldElement4.abs();
            n4 = 0;
            ++n5;
            ++n2;
        }
    }

    private T guessX(T t, T[] TArray, T[] TArray2, int n, int n2) {
        int n3;
        for (int i2 = n; i2 < n2 - 1; ++i2) {
            n3 = i2 + 1 - n;
            for (int i3 = n2 - 1; i3 > i2; --i3) {
                TArray[i3] = (RealFieldElement)((RealFieldElement)TArray[i3].subtract(TArray[i3 - 1])).divide(TArray2[i3].subtract(TArray2[i3 - n3]));
            }
        }
        RealFieldElement realFieldElement = (RealFieldElement)this.field.getZero();
        for (n3 = n2 - 1; n3 >= n; --n3) {
            realFieldElement = (RealFieldElement)TArray[n3].add(realFieldElement.multiply(t.subtract(TArray2[n3])));
        }
        return (T)realFieldElement;
    }
}

