/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoBracketingException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

public class BrentSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BrentSolver() {
        this(1.0E-6);
    }

    public BrentSolver(double d2) {
        super(d2);
    }

    public BrentSolver(double d2, double d3) {
        super(d2, d3);
    }

    public BrentSolver(double d2, double d3, double d4) {
        super(d2, d3, d4);
    }

    protected double doSolve() {
        double d2;
        double d3;
        double d4;
        double d5 = this.getMin();
        double d6 = this.getMax();
        double d7 = this.getStartValue();
        double d8 = this.getFunctionValueAccuracy();
        this.verifySequence(d5, d7, d6);
        double d9 = this.computeObjectiveValue(d7);
        if (FastMath.abs(d4) <= d8) {
            return d7;
        }
        double d10 = this.computeObjectiveValue(d5);
        if (FastMath.abs(d3) <= d8) {
            return d5;
        }
        if (d9 * d10 < 0.0) {
            return this.brent(d5, d7, d10, d9);
        }
        double d11 = this.computeObjectiveValue(d6);
        if (FastMath.abs(d2) <= d8) {
            return d6;
        }
        if (d9 * d11 < 0.0) {
            return this.brent(d7, d6, d9, d11);
        }
        throw new NoBracketingException(d5, d6, d10, d11);
    }

    private double brent(double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d2;
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d7;
        double d12 = d8;
        double d13 = d6 = d9 - d7;
        double d14 = this.getAbsoluteAccuracy();
        double d15 = this.getRelativeAccuracy();
        while (true) {
            double d16;
            if (FastMath.abs(d12) < FastMath.abs(d10)) {
                d7 = d9;
                d9 = d11;
                d11 = d7;
                d8 = d10;
                d10 = d12;
                d12 = d8;
            }
            double d17 = d15 * 2.0 * FastMath.abs(d9) + d14;
            double d18 = 0.5 * (d11 - d9);
            if (FastMath.abs(d18) <= d17 || Precision.equals(d10, 0.0)) {
                return d9;
            }
            if (FastMath.abs(d13) < d17 || FastMath.abs(d8) <= FastMath.abs(d10)) {
                d13 = d6 = d18;
            } else {
                double d19;
                double d20;
                double d21 = d10 / d8;
                if (d7 == d11) {
                    d20 = d18 * 2.0 * d21;
                    d19 = 1.0 - d21;
                } else {
                    d19 = d8 / d12;
                    double d22 = d10 / d12;
                    d20 = d21 * (d18 * 2.0 * d19 * (d19 - d22) - (d9 - d7) * (d22 - 1.0));
                    d19 = (d19 - 1.0) * (d22 - 1.0) * (d21 - 1.0);
                }
                if (d20 > 0.0) {
                    d19 = -d19;
                } else {
                    d20 = -d20;
                }
                d21 = d13;
                d13 = d6;
                if (d20 >= d18 * 1.5 * d19 - FastMath.abs(d17 * d19) || d20 >= FastMath.abs(d21 * 0.5 * d19)) {
                    d13 = d6 = d18;
                } else {
                    d6 = d20 / d19;
                }
            }
            d7 = d9;
            d8 = d10;
            d9 = FastMath.abs(d6) > d17 ? (d9 += d6) : (d18 > 0.0 ? (d9 += d17) : (d9 -= d17));
            d10 = this.computeObjectiveValue(d9);
            if (!(d16 > 0.0 && d12 > 0.0) && (!(d10 <= 0.0) || !(d12 <= 0.0))) continue;
            d11 = d7;
            d12 = d8;
            d13 = d6 = d9 - d7;
        }
    }
}

