/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AllowedSolution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoBracketingException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BracketingNthOrderBrentSolver
extends AbstractUnivariateSolver
implements BracketedUnivariateSolver<UnivariateFunction> {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final int DEFAULT_MAXIMAL_ORDER = 5;
    private static final int MAXIMAL_AGING = 2;
    private static final double REDUCTION_FACTOR = 0.0625;
    private final int maximalOrder;
    private AllowedSolution allowed;

    public BracketingNthOrderBrentSolver() {
        this(1.0E-6, 5);
    }

    public BracketingNthOrderBrentSolver(double d2, int n) {
        super(d2);
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.maximalOrder = n;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public BracketingNthOrderBrentSolver(double d2, double d3, int n) {
        super(d2, d3);
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.maximalOrder = n;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public BracketingNthOrderBrentSolver(double d2, double d3, double d4, int n) {
        super(d2, d3, d4);
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.maximalOrder = n;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public int getMaximalOrder() {
        return this.maximalOrder;
    }

    @Override
    protected double doSolve() {
        int n;
        int n2;
        double[] dArray = new double[this.maximalOrder + 1];
        double[] dArray2 = new double[this.maximalOrder + 1];
        dArray[0] = this.getMin();
        dArray[1] = this.getStartValue();
        dArray[2] = this.getMax();
        this.verifySequence(dArray[0], dArray[1], dArray[2]);
        dArray2[1] = this.computeObjectiveValue(dArray[1]);
        if (Precision.equals(dArray2[1], 0.0, 1)) {
            return dArray[1];
        }
        dArray2[0] = this.computeObjectiveValue(dArray[0]);
        if (Precision.equals(dArray2[0], 0.0, 1)) {
            return dArray[0];
        }
        if (dArray2[0] * dArray2[1] < 0.0) {
            n2 = 2;
            n = 1;
        } else {
            dArray2[2] = this.computeObjectiveValue(dArray[2]);
            if (Precision.equals(dArray2[2], 0.0, 1)) {
                return dArray[2];
            }
            if (dArray2[1] * dArray2[2] < 0.0) {
                n2 = 3;
                n = 2;
            } else {
                throw new NoBracketingException(dArray[0], dArray[2], dArray2[0], dArray2[2]);
            }
        }
        double[] dArray3 = new double[dArray.length];
        double d2 = dArray[n - 1];
        double d3 = dArray2[n - 1];
        double d4 = FastMath.abs(d3);
        int n3 = 0;
        double d5 = dArray[n];
        double d6 = dArray2[n];
        double d7 = FastMath.abs(d6);
        int n4 = 0;
        while (true) {
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            if (d5 - d2 <= (d12 = this.getAbsoluteAccuracy() + this.getRelativeAccuracy() * FastMath.max(FastMath.abs(d2), FastMath.abs(d5))) || FastMath.max(d4, d7) < this.getFunctionValueAccuracy()) {
                switch (this.allowed) {
                    case ANY_SIDE: {
                        if (d4 < d7) {
                            return d2;
                        }
                        return d5;
                    }
                    case LEFT_SIDE: {
                        return d2;
                    }
                    case RIGHT_SIDE: {
                        return d5;
                    }
                    case BELOW_SIDE: {
                        if (d3 <= 0.0) {
                            return d2;
                        }
                        return d5;
                    }
                    case ABOVE_SIDE: {
                        if (d3 < 0.0) {
                            return d5;
                        }
                        return d2;
                    }
                }
                throw new MathInternalError();
            }
            if (n3 >= 2) {
                int n5 = n3 - 2;
                d11 = (1 << n5) - 1;
                double d13 = n5 + 1;
                d10 = (d11 * d3 - d13 * 0.0625 * d6) / (d11 + d13);
            } else if (n4 >= 2) {
                int n6 = n4 - 2;
                d11 = n6 + 1;
                double d14 = (1 << n6) - 1;
                d10 = (d14 * d6 - d11 * 0.0625 * d3) / (d11 + d14);
            } else {
                d10 = 0.0;
            }
            int n7 = 0;
            int n8 = n2;
            do {
                double d15;
                System.arraycopy(dArray, n7, dArray3, n7, n8 - n7);
                d9 = this.guessX(d10, dArray3, dArray2, n7, n8);
                if (d15 > d2 && d9 < d5) continue;
                if (n - n7 >= n8 - n) {
                    ++n7;
                } else {
                    --n8;
                }
                d9 = Double.NaN;
            } while (Double.isNaN(d9) && n8 - n7 > 1);
            if (Double.isNaN(d9)) {
                d9 = d2 + 0.5 * (d5 - d2);
                n7 = n - 1;
                n8 = n;
            }
            if (Precision.equals(d8 = this.computeObjectiveValue(d9), 0.0, 1)) {
                return d9;
            }
            if (n2 > 2 && n8 - n7 != n2) {
                n2 = n8 - n7;
                System.arraycopy(dArray, n7, dArray, 0, n2);
                System.arraycopy(dArray2, n7, dArray2, 0, n2);
                n -= n7;
            } else if (n2 == dArray.length) {
                --n2;
                if (n >= (dArray.length + 1) / 2) {
                    System.arraycopy(dArray, 1, dArray, 0, n2);
                    System.arraycopy(dArray2, 1, dArray2, 0, n2);
                    --n;
                }
            }
            System.arraycopy(dArray, n, dArray, n + 1, n2 - n);
            dArray[n] = d9;
            System.arraycopy(dArray2, n, dArray2, n + 1, n2 - n);
            dArray2[n] = d8;
            ++n2;
            if (d8 * d3 <= 0.0) {
                d5 = d9;
                d6 = d8;
                d7 = FastMath.abs(d6);
                ++n3;
                n4 = 0;
                continue;
            }
            d2 = d9;
            d3 = d8;
            d4 = FastMath.abs(d3);
            n3 = 0;
            ++n4;
            ++n;
        }
    }

    private double guessX(double d2, double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        for (int i2 = n; i2 < n2 - 1; ++i2) {
            int n4 = i2 + 1 - n;
            for (n3 = n2 - 1; n3 > i2; --n3) {
                dArray[n3] = (dArray[n3] - dArray[n3 - 1]) / (dArray2[n3] - dArray2[n3 - n4]);
            }
        }
        double d3 = 0.0;
        for (n3 = n2 - 1; n3 >= n; --n3) {
            d3 = dArray[n3] + d3 * (d2 - dArray2[n3]);
        }
        return d3;
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3, AllowedSolution allowedSolution) {
        this.allowed = allowedSolution;
        return super.solve(n, univariateFunction, d2, d3);
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3, double d4, AllowedSolution allowedSolution) {
        this.allowed = allowedSolution;
        return super.solve(n, univariateFunction, d2, d3, d4);
    }
}

