/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class BisectionSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BisectionSolver() {
        this(1.0E-6);
    }

    public BisectionSolver(double d2) {
        super(d2);
    }

    public BisectionSolver(double d2, double d3) {
        super(d2, d3);
    }

    protected double doSolve() {
        double d2;
        double d3 = this.getMin();
        double d4 = this.getMax();
        this.verifyInterval(d3, d4);
        double d5 = this.getAbsoluteAccuracy();
        do {
            double d6;
            d2 = UnivariateSolverUtils.midpoint(d3, d4);
            double d7 = this.computeObjectiveValue(d3);
            double d8 = this.computeObjectiveValue(d2);
            if (d6 * d7 > 0.0) {
                d3 = d2;
                continue;
            }
            d4 = d2;
        } while (!(FastMath.abs(d4 - d3) <= d5));
        d2 = UnivariateSolverUtils.midpoint(d3, d4);
        return d2;
    }
}

