/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AllowedSolution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BaseSecantSolver$Method;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSecantSolver
extends AbstractUnivariateSolver
implements BracketedUnivariateSolver<UnivariateFunction> {
    protected static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private AllowedSolution allowed = AllowedSolution.ANY_SIDE;
    private final BaseSecantSolver$Method method;

    protected BaseSecantSolver(double d2, BaseSecantSolver$Method baseSecantSolver$Method) {
        super(d2);
        this.method = baseSecantSolver$Method;
    }

    protected BaseSecantSolver(double d2, double d3, BaseSecantSolver$Method baseSecantSolver$Method) {
        super(d2, d3);
        this.method = baseSecantSolver$Method;
    }

    protected BaseSecantSolver(double d2, double d3, double d4, BaseSecantSolver$Method baseSecantSolver$Method) {
        super(d2, d3, d4);
        this.method = baseSecantSolver$Method;
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3, AllowedSolution allowedSolution) {
        return this.solve(n, univariateFunction, d2, d3, d2 + 0.5 * (d3 - d2), allowedSolution);
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3, double d4, AllowedSolution allowedSolution) {
        this.allowed = allowedSolution;
        return super.solve(n, univariateFunction, d2, d3, d4);
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        return this.solve(n, univariateFunction, d2, d3, d4, AllowedSolution.ANY_SIDE);
    }

    @Override
    protected final double doSolve() {
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = this.computeObjectiveValue(d2);
        double d5 = this.computeObjectiveValue(d3);
        if (d4 == 0.0) {
            return d2;
        }
        if (d5 == 0.0) {
            return d3;
        }
        this.verifyBracketing(d2, d3);
        double d6 = this.getFunctionValueAccuracy();
        double d7 = this.getAbsoluteAccuracy();
        double d8 = this.getRelativeAccuracy();
        boolean bl = false;
        block19: do {
            double d9;
            double d10;
            double d11;
            if ((d11 = this.computeObjectiveValue(d10 = d3 - d5 * (d3 - d2) / (d5 - d4))) == 0.0) {
                return d10;
            }
            if (d5 * d11 < 0.0) {
                d2 = d3;
                d4 = d5;
                bl = !bl;
            } else {
                switch (this.method) {
                    case ILLINOIS: {
                        d4 *= 0.5;
                        break;
                    }
                    case PEGASUS: {
                        double d12 = d5;
                        d4 *= d12 / (d12 + d11);
                        break;
                    }
                    case REGULA_FALSI: {
                        if (d10 != d3) break;
                        throw new ConvergenceException();
                    }
                    default: {
                        throw new MathInternalError();
                    }
                }
            }
            d3 = d10;
            d5 = d11;
            if (!(FastMath.abs(d9) <= d6)) continue;
            switch (this.allowed) {
                case ANY_SIDE: {
                    return d3;
                }
                case LEFT_SIDE: {
                    if (!bl) continue block19;
                    return d3;
                }
                case RIGHT_SIDE: {
                    if (bl) continue block19;
                    return d3;
                }
                case BELOW_SIDE: {
                    if (!(d5 <= 0.0)) continue block19;
                    return d3;
                }
                case ABOVE_SIDE: {
                    if (!(d5 >= 0.0)) continue block19;
                    return d3;
                }
                default: {
                    throw new MathInternalError();
                }
            }
        } while (!(FastMath.abs(d3 - d2) < FastMath.max(d8 * FastMath.abs(d3), d7)));
        switch (this.allowed) {
            case ANY_SIDE: {
                return d3;
            }
            case LEFT_SIDE: {
                if (bl) {
                    return d3;
                }
                return d2;
            }
            case RIGHT_SIDE: {
                if (bl) {
                    return d2;
                }
                return d3;
            }
            case BELOW_SIDE: {
                if (d5 <= 0.0) {
                    return d3;
                }
                return d2;
            }
            case ABOVE_SIDE: {
                if (d5 >= 0.0) {
                    return d3;
                }
                return d2;
            }
        }
        throw new MathInternalError();
    }
}

