/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$4;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$5;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$JacobiKey;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialsUtils$RecurrenceCoefficientsGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialsUtils {
    private static final List<BigFraction> CHEBYSHEV_COEFFICIENTS = new ArrayList<BigFraction>();
    private static final List<BigFraction> HERMITE_COEFFICIENTS;
    private static final List<BigFraction> LAGUERRE_COEFFICIENTS;
    private static final List<BigFraction> LEGENDRE_COEFFICIENTS;
    private static final Map<PolynomialsUtils$JacobiKey, List<BigFraction>> JACOBI_COEFFICIENTS;

    private PolynomialsUtils() {
    }

    public static PolynomialFunction createChebyshevPolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, CHEBYSHEV_COEFFICIENTS, new PolynomialsUtils$1());
    }

    public static PolynomialFunction createHermitePolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, HERMITE_COEFFICIENTS, new PolynomialsUtils$2());
    }

    public static PolynomialFunction createLaguerrePolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, LAGUERRE_COEFFICIENTS, new PolynomialsUtils$3());
    }

    public static PolynomialFunction createLegendrePolynomial(int n) {
        return PolynomialsUtils.buildPolynomial(n, LEGENDRE_COEFFICIENTS, new PolynomialsUtils$4());
    }

    public static PolynomialFunction createJacobiPolynomial(int n, int n2, int n3) {
        PolynomialsUtils$JacobiKey polynomialsUtils$JacobiKey = new PolynomialsUtils$JacobiKey(n2, n3);
        if (!JACOBI_COEFFICIENTS.containsKey(polynomialsUtils$JacobiKey)) {
            ArrayList<BigFraction> arrayList = new ArrayList<BigFraction>();
            JACOBI_COEFFICIENTS.put(polynomialsUtils$JacobiKey, arrayList);
            arrayList.add(BigFraction.ONE);
            arrayList.add(new BigFraction(n2 - n3, 2));
            arrayList.add(new BigFraction(n2 + 2 + n3, 2));
        }
        return PolynomialsUtils.buildPolynomial(n, JACOBI_COEFFICIENTS.get(polynomialsUtils$JacobiKey), new PolynomialsUtils$5(n2, n3));
    }

    public static double[] shift(double[] dArray, double d2) {
        int n;
        int n2;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        int n4 = n3;
        int[][] nArray = new int[n4][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n <= n2; ++n) {
                nArray[n2][n] = (int)CombinatoricsUtils.binomialCoefficient(n2, n);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[0] = dArray2[0] + dArray[n2] * FastMath.pow(d2, n2);
        }
        n2 = n3 - 1;
        for (n = 0; n < n2; ++n) {
            for (n3 = n; n3 < n2; ++n3) {
                int n5 = n + 1;
                dArray2[n5] = dArray2[n5] + (double)nArray[n3 + 1][n3 - n] * dArray[n3 + 1] * FastMath.pow(d2, n3 - n);
            }
        }
        return dArray2;
    }

    private static PolynomialFunction buildPolynomial(int n, List<BigFraction> list, PolynomialsUtils$RecurrenceCoefficientsGenerator polynomialsUtils$RecurrenceCoefficientsGenerator) {
        List<BigFraction> list2 = list;
        synchronized (list2) {
            int n2 = (int)FastMath.floor(FastMath.sqrt(2 * list.size())) - 1;
            if (n > n2) {
                PolynomialsUtils.computeUpToDegree(n, n2, polynomialsUtils$RecurrenceCoefficientsGenerator, list);
            }
        }
        int n3 = n;
        int n4 = n3 * (n3 + 1) / 2;
        double[] dArray = new double[n + 1];
        for (int i2 = 0; i2 <= n; ++i2) {
            dArray[i2] = list.get(n4 + i2).doubleValue();
        }
        return new PolynomialFunction(dArray);
    }

    private static void computeUpToDegree(int n, int n2, PolynomialsUtils$RecurrenceCoefficientsGenerator polynomialsUtils$RecurrenceCoefficientsGenerator, List<BigFraction> list) {
        int n3 = (n2 - 1) * n2 / 2;
        while (n2 < n) {
            int n4 = n3;
            BigFraction[] bigFractionArray = polynomialsUtils$RecurrenceCoefficientsGenerator.generate(n2);
            BigFraction bigFraction = list.get(n3 += n2);
            BigFraction bigFraction2 = list.get(n4);
            list.add(bigFraction.multiply(bigFractionArray[0]).subtract(bigFraction2.multiply(bigFractionArray[2])));
            for (int i2 = 1; i2 < n2; ++i2) {
                BigFraction bigFraction3 = bigFraction;
                bigFraction = list.get(n3 + i2);
                bigFraction2 = list.get(n4 + i2);
                list.add(bigFraction.multiply(bigFractionArray[0]).add(bigFraction3.multiply(bigFractionArray[1])).subtract(bigFraction2.multiply(bigFractionArray[2])));
            }
            BigFraction bigFraction4 = bigFraction;
            bigFraction = list.get(n3 + n2);
            list.add(bigFraction.multiply(bigFractionArray[0]).add(bigFraction4.multiply(bigFractionArray[1])));
            list.add(bigFraction.multiply(bigFractionArray[1]));
            ++n2;
        }
    }

    static {
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ZERO);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS = new ArrayList<BigFraction>();
        HERMITE_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS.add(BigFraction.ZERO);
        HERMITE_COEFFICIENTS.add(BigFraction.TWO);
        LAGUERRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.MINUS_ONE);
        LEGENDRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ZERO);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        JACOBI_COEFFICIENTS = new HashMap<PolynomialsUtils$JacobiKey, List<BigFraction>>();
    }
}

