/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Arrays;

public class PolynomialSplineFunction
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private final double[] knots;
    private final PolynomialFunction[] polynomials;
    private final int n;

    public PolynomialSplineFunction(double[] dArray, PolynomialFunction[] polynomialFunctionArray) {
        if (dArray == null || polynomialFunctionArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NOT_ENOUGH_POINTS_IN_SPLINE_PARTITION, (Number)2, dArray.length, false);
        }
        if (dArray.length - 1 != polynomialFunctionArray.length) {
            throw new DimensionMismatchException(polynomialFunctionArray.length, dArray.length);
        }
        MathArrays.checkOrder(dArray);
        this.n = dArray.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(dArray, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomialFunctionArray, 0, this.polynomials, 0, this.n);
    }

    public double value(double d2) {
        if (d2 < this.knots[0] || d2 > this.knots[this.n]) {
            throw new OutOfRangeException(d2, (Number)this.knots[0], this.knots[this.n]);
        }
        int n = Arrays.binarySearch(this.knots, d2);
        if (n < 0) {
            n = -n - 2;
        }
        if (n >= this.polynomials.length) {
            --n;
        }
        return this.polynomials[n].value(d2 - this.knots[n]);
    }

    public UnivariateFunction derivative() {
        return this.polynomialSplineDerivative();
    }

    public PolynomialSplineFunction polynomialSplineDerivative() {
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            polynomialFunctionArray[i2] = this.polynomials[i2].polynomialDerivative();
        }
        return new PolynomialSplineFunction(this.knots, polynomialFunctionArray);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d2 = derivativeStructure.getValue();
        if (d2 < this.knots[0] || d2 > this.knots[this.n]) {
            throw new OutOfRangeException(d2, (Number)this.knots[0], this.knots[this.n]);
        }
        int n = Arrays.binarySearch(this.knots, d2);
        if (n < 0) {
            n = -n - 2;
        }
        if (n >= this.polynomials.length) {
            --n;
        }
        return this.polynomials[n].value(derivativeStructure.subtract(this.knots[n]));
    }

    public int getN() {
        return this.n;
    }

    public PolynomialFunction[] getPolynomials() {
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[this.n];
        System.arraycopy(this.polynomials, 0, polynomialFunctionArray, 0, this.n);
        return polynomialFunctionArray;
    }

    public double[] getKnots() {
        double[] dArray = new double[this.n + 1];
        System.arraycopy(this.knots, 0, dArray, 0, this.n + 1);
        return dArray;
    }

    public boolean isValidPoint(double d2) {
        return !(d2 < this.knots[0]) && !(d2 > this.knots[this.n]);
    }
}

