/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

public class PolynomialFunctionNewtonForm
implements UnivariateDifferentiableFunction {
    private double[] coefficients;
    private final double[] c;
    private final double[] a;
    private boolean coefficientsComputed;

    public PolynomialFunctionNewtonForm(double[] dArray, double[] dArray2) {
        PolynomialFunctionNewtonForm.verifyInputArray(dArray, dArray2);
        this.a = new double[dArray.length];
        this.c = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.a, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.c, 0, dArray2.length);
        this.coefficientsComputed = false;
    }

    public double value(double d2) {
        return PolynomialFunctionNewtonForm.evaluate(this.a, this.c, d2);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        PolynomialFunctionNewtonForm.verifyInputArray(this.a, this.c);
        int n = this.c.length;
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(derivativeStructure.getFreeParameters(), derivativeStructure.getOrder(), this.a[n]);
        --n;
        while (n >= 0) {
            derivativeStructure2 = derivativeStructure.subtract(this.c[n]).multiply(derivativeStructure2).add(this.a[n]);
            --n;
        }
        return derivativeStructure2;
    }

    public int degree() {
        return this.c.length;
    }

    public double[] getNewtonCoefficients() {
        double[] dArray = new double[this.a.length];
        System.arraycopy(this.a, 0, dArray, 0, this.a.length);
        return dArray;
    }

    public double[] getCenters() {
        double[] dArray = new double[this.c.length];
        System.arraycopy(this.c, 0, dArray, 0, this.c.length);
        return dArray;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] dArray = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, dArray, 0, this.coefficients.length);
        return dArray;
    }

    public static double evaluate(double[] dArray, double[] dArray2, double d2) {
        PolynomialFunctionNewtonForm.verifyInputArray(dArray, dArray2);
        int n = dArray2.length;
        double d3 = dArray[n];
        --n;
        while (n >= 0) {
            d3 = dArray[n] + (d2 - dArray2[n]) * d3;
            --n;
        }
        return d3;
    }

    protected void computeCoefficients() {
        int n;
        int n2 = this.degree();
        this.coefficients = new double[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            this.coefficients[n] = 0.0;
        }
        this.coefficients[0] = this.a[n2];
        for (n = n2 - 1; n >= 0; --n) {
            for (int i2 = n2 - n; i2 > 0; --i2) {
                this.coefficients[i2] = this.coefficients[i2 - 1] - this.c[n] * this.coefficients[i2];
            }
            this.coefficients[0] = this.a[n] - this.c[n] * this.coefficients[0];
        }
        this.coefficientsComputed = true;
    }

    protected static void verifyInputArray(double[] dArray, double[] dArray2) {
        MathUtils.checkNotNull(dArray);
        MathUtils.checkNotNull(dArray2);
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (dArray.length != dArray2.length + 1) {
            throw new DimensionMismatchException((Localizable)LocalizedFormats.ARRAY_SIZES_SHOULD_HAVE_DIFFERENCE_1, dArray.length, dArray2.length);
        }
    }
}

