/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays$OrderDirection;

public class PolynomialFunctionLagrangeForm
implements UnivariateFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] dArray, double[] dArray2) {
        this.x = new double[dArray.length];
        this.y = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.x, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.y, 0, dArray2.length);
        this.coefficientsComputed = false;
        if (!PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray, dArray2, false)) {
            MathArrays.sortInPlace(this.x, new double[][]{this.y});
            PolynomialFunctionLagrangeForm.verifyInterpolationArray(this.x, this.y, true);
        }
    }

    public double value(double d2) {
        return PolynomialFunctionLagrangeForm.evaluateInternal(this.x, this.y, d2);
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] dArray = new double[this.x.length];
        System.arraycopy(this.x, 0, dArray, 0, this.x.length);
        return dArray;
    }

    public double[] getInterpolatingValues() {
        double[] dArray = new double[this.y.length];
        System.arraycopy(this.y, 0, dArray, 0, this.y.length);
        return dArray;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] dArray = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, dArray, 0, this.coefficients.length);
        return dArray;
    }

    public static double evaluate(double[] dArray, double[] dArray2, double d2) {
        if (PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray, dArray2, false)) {
            return PolynomialFunctionLagrangeForm.evaluateInternal(dArray, dArray2, d2);
        }
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length);
        MathArrays.sortInPlace(dArray3, new double[][]{dArray4});
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(dArray3, dArray4, true);
        return PolynomialFunctionLagrangeForm.evaluateInternal(dArray3, dArray4, d2);
    }

    private static double evaluateInternal(double[] dArray, double[] dArray2, double d2) {
        int n = 0;
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double d3 = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4;
            dArray3[i2] = dArray2[i2];
            dArray4[i2] = dArray2[i2];
            double d5 = FastMath.abs(d2 - dArray[i2]);
            if (!(d4 < d3)) continue;
            n = i2;
            d3 = d5;
        }
        double d6 = dArray2[n];
        for (int i3 = 1; i3 < n2; ++i3) {
            for (int i4 = 0; i4 < n2 - i3; ++i4) {
                double d7 = dArray[i4] - d2;
                double d8 = dArray[i3 + i4] - d2;
                double d9 = dArray[i4] - dArray[i3 + i4];
                double d10 = (dArray3[i4 + 1] - dArray4[i4]) / d9;
                dArray3[i4] = d7 * d10;
                dArray4[i4] = d8 * d10;
            }
            if ((double)n < 0.5 * (double)(n2 - i3 + 1)) {
                d6 += dArray3[n];
                continue;
            }
            d6 += dArray4[--n];
        }
        return d6;
    }

    protected void computeCoefficients() {
        int n;
        int n2 = this.degree() + 1;
        this.coefficients = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.coefficients[i2] = 0.0;
        }
        double[] dArray = new double[n2 + 1];
        double[] dArray2 = dArray;
        dArray[0] = 1.0;
        for (int i3 = 0; i3 < n2; ++i3) {
            for (n = i3; n > 0; --n) {
                dArray2[n] = dArray2[n - 1] - dArray2[n] * this.x[i3];
            }
            dArray2[0] = dArray2[0] * -this.x[i3];
            dArray2[i3 + 1] = 1.0;
        }
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d2 = 1.0;
            for (int i4 = 0; i4 < n2; ++i4) {
                if (n == i4) continue;
                d2 *= this.x[n] - this.x[i4];
            }
            double d3 = this.y[n] / d2;
            dArray3[n2 - 1] = dArray2[n2];
            int n3 = n2 - 1;
            this.coefficients[n3] = this.coefficients[n3] + d3 * dArray3[n2 - 1];
            for (int i5 = n2 - 2; i5 >= 0; --i5) {
                dArray3[i5] = dArray2[i5 + 1] + dArray3[i5 + 1] * this.x[n];
                int n4 = i5;
                this.coefficients[n4] = this.coefficients[n4] + d3 * dArray3[i5];
            }
        }
        this.coefficientsComputed = true;
    }

    public static boolean verifyInterpolationArray(double[] dArray, double[] dArray2, boolean bl) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)2, dArray.length, true);
        }
        return MathArrays.checkOrder(dArray, MathArrays$OrderDirection.INCREASING, true, bl);
    }
}

