/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.util.Arrays;

public class PolynomialFunction
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction,
Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    public PolynomialFunction(double[] dArray) {
        int n;
        MathUtils.checkNotNull(dArray);
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        for (n = dArray.length; n > 1 && dArray[n - 1] == 0.0; --n) {
        }
        this.coefficients = new double[n];
        System.arraycopy(dArray, 0, this.coefficients, 0, n);
    }

    public double value(double d2) {
        return PolynomialFunction.evaluate(this.coefficients, d2);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    protected static double evaluate(double[] dArray, double d2) {
        MathUtils.checkNotNull(dArray);
        int n = dArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        double d3 = dArray[n - 1];
        n -= 2;
        while (n >= 0) {
            d3 = d2 * d3 + dArray[n];
            --n;
        }
        return d3;
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        MathUtils.checkNotNull(this.coefficients);
        int n = this.coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(derivativeStructure.getFreeParameters(), derivativeStructure.getOrder(), this.coefficients[n - 1]);
        n -= 2;
        while (n >= 0) {
            derivativeStructure2 = derivativeStructure2.multiply(derivativeStructure).add(this.coefficients[n]);
            --n;
        }
        return derivativeStructure2;
    }

    public PolynomialFunction add(PolynomialFunction polynomialFunction) {
        int n = FastMath.min(this.coefficients.length, polynomialFunction.coefficients.length);
        int n2 = FastMath.max(this.coefficients.length, polynomialFunction.coefficients.length);
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.coefficients[i2] + polynomialFunction.coefficients[i2];
        }
        System.arraycopy(this.coefficients.length < polynomialFunction.coefficients.length ? polynomialFunction.coefficients : this.coefficients, n, dArray, n, n2 - n);
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction subtract(PolynomialFunction polynomialFunction) {
        int n;
        int n2 = FastMath.min(this.coefficients.length, polynomialFunction.coefficients.length);
        int n3 = FastMath.max(this.coefficients.length, polynomialFunction.coefficients.length);
        double[] dArray = new double[n3];
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.coefficients[n] - polynomialFunction.coefficients[n];
        }
        if (this.coefficients.length < polynomialFunction.coefficients.length) {
            for (n = n2; n < n3; ++n) {
                dArray[n] = -polynomialFunction.coefficients[n];
            }
        } else {
            System.arraycopy(this.coefficients, n2, dArray, n2, n3 - n2);
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction negate() {
        double[] dArray = new double[this.coefficients.length];
        for (int i2 = 0; i2 < this.coefficients.length; ++i2) {
            dArray[i2] = -this.coefficients[i2];
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction multiply(PolynomialFunction polynomialFunction) {
        double[] dArray = new double[this.coefficients.length + polynomialFunction.coefficients.length - 1];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = 0.0;
            for (int i3 = FastMath.max(0, i2 + 1 - polynomialFunction.coefficients.length); i3 < FastMath.min(this.coefficients.length, i2 + 1); ++i3) {
                int n = i2;
                dArray[n] = dArray[n] + this.coefficients[i3] * polynomialFunction.coefficients[i2 - i3];
            }
        }
        return new PolynomialFunction(dArray);
    }

    protected static double[] differentiate(double[] dArray) {
        MathUtils.checkNotNull(dArray);
        int n = dArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] dArray2 = new double[n - 1];
        --n;
        while (n > 0) {
            dArray2[n - 1] = (double)n * dArray[n];
            --n;
        }
        return dArray2;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    public UnivariateFunction derivative() {
        return this.polynomialDerivative();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            stringBuilder.append(PolynomialFunction.toString(this.coefficients[0]));
        }
        for (int i2 = 1; i2 < this.coefficients.length; ++i2) {
            if (this.coefficients[i2] == 0.0) continue;
            if (stringBuilder.length() > 0) {
                if (this.coefficients[i2] < 0.0) {
                    stringBuilder.append(" - ");
                } else {
                    stringBuilder.append(" + ");
                }
            } else if (this.coefficients[i2] < 0.0) {
                stringBuilder.append("-");
            }
            double d2 = FastMath.abs(this.coefficients[i2]);
            if (d2 - 1.0 != 0.0) {
                stringBuilder.append(PolynomialFunction.toString(d2));
                stringBuilder.append(' ');
            }
            stringBuilder.append("x");
            if (i2 <= 1) continue;
            stringBuilder.append('^');
            stringBuilder.append(Integer.toString(i2));
        }
        return stringBuilder.toString();
    }

    private static String toString(double d2) {
        String string = Double.toString(d2);
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public int hashCode() {
        int n = 31 + Arrays.hashCode(this.coefficients);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PolynomialFunction)) {
            return false;
        }
        object = (PolynomialFunction)object;
        return Arrays.equals(this.coefficients, ((PolynomialFunction)object).coefficients);
    }
}

