/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.UnivariatePeriodicInterpolator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

public class UnivariatePeriodicInterpolator
implements UnivariateInterpolator {
    public static final int DEFAULT_EXTEND = 5;
    private final UnivariateInterpolator interpolator;
    private final double period;
    private final int extend;

    public UnivariatePeriodicInterpolator(UnivariateInterpolator univariateInterpolator, double d2, int n) {
        this.interpolator = univariateInterpolator;
        this.period = d2;
        this.extend = n;
    }

    public UnivariatePeriodicInterpolator(UnivariateInterpolator univariateInterpolator, double d2) {
        this(univariateInterpolator, d2, 5);
    }

    public UnivariateFunction interpolate(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        if (dArray.length < this.extend) {
            throw new NumberIsTooSmallException(dArray.length, (Number)this.extend, true);
        }
        MathArrays.checkOrder(dArray);
        double d2 = dArray[0];
        int n3 = dArray.length + (this.extend << 1);
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            n = n2 + this.extend;
            dArray3[n] = MathUtils.reduce(dArray[n2], this.period, d2);
            dArray4[n] = dArray2[n2];
        }
        for (n2 = 0; n2 < this.extend; ++n2) {
            n = dArray.length - this.extend + n2;
            dArray3[n2] = MathUtils.reduce(dArray[n], this.period, d2) - this.period;
            dArray4[n2] = dArray2[n];
            n = n3 - this.extend + n2;
            dArray3[n] = MathUtils.reduce(dArray[n2], this.period, d2) + this.period;
            dArray4[n] = dArray2[n2];
        }
        MathArrays.sortInPlace(dArray3, new double[][]{dArray4});
        UnivariateFunction univariateFunction = this.interpolator.interpolate(dArray3, dArray4);
        return new UnivariatePeriodicInterpolator$1(this, univariateFunction, d2);
    }

    static /* synthetic */ double access$000(UnivariatePeriodicInterpolator univariatePeriodicInterpolator) {
        return univariatePeriodicInterpolator.period;
    }
}

