/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.TricubicInterpolatingFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.TricubicInterpolator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.TrivariateGridInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class TricubicInterpolator
implements TrivariateGridInterpolator {
    public TricubicInterpolatingFunction interpolate(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4) {
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0 || dArray4.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray4.length) {
            throw new DimensionMismatchException(dArray.length, dArray4.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        MathArrays.checkOrder(dArray3);
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = dArray3.length;
        double[][][] dArray5 = new double[n][n2][n3];
        double[][][] dArray6 = new double[n][n2][n3];
        double[][][] dArray7 = new double[n][n2][n3];
        double[][][] dArray8 = new double[n][n2][n3];
        double[][][] dArray9 = new double[n][n2][n3];
        double[][][] dArray10 = new double[n][n2][n3];
        double[][][] dArray11 = new double[n][n2][n3];
        for (int i2 = 1; i2 < n - 1; ++i2) {
            if (dArray2.length != dArray4[i2].length) {
                throw new DimensionMismatchException(dArray2.length, dArray4[i2].length);
            }
            int n4 = i2 + 1;
            int n5 = i2 - 1;
            double d2 = dArray[n4];
            double d3 = dArray[n5];
            double d4 = d2 - d3;
            for (int i3 = 1; i3 < n2 - 1; ++i3) {
                if (dArray3.length != dArray4[i2][i3].length) {
                    throw new DimensionMismatchException(dArray3.length, dArray4[i2][i3].length);
                }
                int n6 = i3 + 1;
                int n7 = i3 - 1;
                double d5 = dArray2[n6];
                double d6 = dArray2[n7];
                double d7 = d5 - d6;
                double d8 = d4 * d7;
                for (int i4 = 1; i4 < n3 - 1; ++i4) {
                    int n8 = i4 + 1;
                    int n9 = i4 - 1;
                    double d9 = dArray3[n8];
                    double d10 = dArray3[n9];
                    double d11 = d9 - d10;
                    dArray5[i2][i3][i4] = (dArray4[n4][i3][i4] - dArray4[n5][i3][i4]) / d4;
                    dArray6[i2][i3][i4] = (dArray4[i2][n6][i4] - dArray4[i2][n7][i4]) / d7;
                    dArray7[i2][i3][i4] = (dArray4[i2][i3][n8] - dArray4[i2][i3][n9]) / d11;
                    double d12 = d4 * d11;
                    double d13 = d7 * d11;
                    dArray8[i2][i3][i4] = (dArray4[n4][n6][i4] - dArray4[n4][n7][i4] - dArray4[n5][n6][i4] + dArray4[n5][n7][i4]) / d8;
                    dArray9[i2][i3][i4] = (dArray4[n4][i3][n8] - dArray4[n4][i3][n9] - dArray4[n5][i3][n8] + dArray4[n5][i3][n9]) / d12;
                    dArray10[i2][i3][i4] = (dArray4[i2][n6][n8] - dArray4[i2][n6][n9] - dArray4[i2][n7][n8] + dArray4[i2][n7][n9]) / d13;
                    double d14 = d8 * d11;
                    dArray11[i2][i3][i4] = (dArray4[n4][n6][n8] - dArray4[n4][n7][n8] - dArray4[n5][n6][n8] + dArray4[n5][n7][n8] - dArray4[n4][n6][n9] + dArray4[n4][n7][n9] + dArray4[n5][n6][n9] - dArray4[n5][n7][n9]) / d14;
                }
            }
        }
        return new TricubicInterpolator$1(this, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, dArray10, dArray11, dArray, dArray2, dArray3);
    }
}

