/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class SplineInterpolator
implements UnivariateInterpolator {
    public PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 3, true);
        }
        int n = dArray.length - 1;
        MathArrays.checkOrder(dArray);
        double[] dArray3 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray3[i2] = dArray[i2 + 1] - dArray[i2];
        }
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n + 1];
        dArray4[0] = 0.0;
        dArray5[0] = 0.0;
        for (int i3 = 1; i3 < n; ++i3) {
            double d2 = 2.0 * (dArray[i3 + 1] - dArray[i3 - 1]) - dArray3[i3 - 1] * dArray4[i3 - 1];
            dArray4[i3] = dArray3[i3] / d2;
            dArray5[i3] = (3.0 * (dArray2[i3 + 1] * dArray3[i3 - 1] - dArray2[i3] * (dArray[i3 + 1] - dArray[i3 - 1]) + dArray2[i3 - 1] * dArray3[i3]) / (dArray3[i3 - 1] * dArray3[i3]) - dArray3[i3 - 1] * dArray5[i3 - 1]) / d2;
        }
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n + 1];
        double[] dArray8 = new double[n];
        dArray5[n] = 0.0;
        dArray7[n] = 0.0;
        for (int i4 = n - 1; i4 >= 0; --i4) {
            dArray7[i4] = dArray5[i4] - dArray4[i4] * dArray7[i4 + 1];
            dArray6[i4] = (dArray2[i4 + 1] - dArray2[i4]) / dArray3[i4] - dArray3[i4] * (dArray7[i4 + 1] + 2.0 * dArray7[i4]) / 3.0;
            dArray8[i4] = (dArray7[i4 + 1] - dArray7[i4]) / (3.0 * dArray3[i4]);
        }
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n];
        dArray3 = new double[4];
        for (int i5 = 0; i5 < n; ++i5) {
            dArray3[0] = dArray2[i5];
            dArray3[1] = dArray6[i5];
            dArray3[2] = dArray7[i5];
            dArray3[3] = dArray8[i5];
            polynomialFunctionArray[i5] = new PolynomialFunction(dArray3);
        }
        return new PolynomialSplineFunction(dArray, polynomialFunctionArray);
    }
}

