/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.BivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.InsufficientDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Arrays;

public class PiecewiseBicubicSplineInterpolatingFunction
implements BivariateFunction {
    private static final int MIN_NUM_POINTS = 5;
    private final double[] xval;
    private final double[] yval;
    private final double[][] fval;

    public PiecewiseBicubicSplineInterpolatingFunction(double[] dArray, double[] dArray2, double[][] dArray3) {
        if (dArray == null || dArray2 == null || dArray3 == null || dArray3[0] == null) {
            throw new NullArgumentException();
        }
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n == 0 || n2 == 0 || dArray3.length == 0 || dArray3[0].length == 0) {
            throw new NoDataException();
        }
        if (n < 5 || n2 < 5 || dArray3.length < 5 || dArray3[0].length < 5) {
            throw new InsufficientDataException();
        }
        if (n != dArray3.length) {
            throw new DimensionMismatchException(n, dArray3.length);
        }
        if (n2 != dArray3[0].length) {
            throw new DimensionMismatchException(n2, dArray3[0].length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        this.xval = (double[])dArray.clone();
        this.yval = (double[])dArray2.clone();
        this.fval = (double[][])dArray3.clone();
    }

    public double value(double d2, double d3) {
        int n;
        AkimaSplineInterpolator akimaSplineInterpolator = new AkimaSplineInterpolator();
        int n2 = this.searchIndex(d2, this.xval, 2, 5);
        int n3 = this.searchIndex(d3, this.yval, 2, 5);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        for (n = 0; n < 5; ++n) {
            dArray[n] = this.xval[n2 + n];
            dArray2[n] = this.yval[n3 + n];
        }
        for (n = 0; n < 5; ++n) {
            for (int i2 = 0; i2 < 5; ++i2) {
                dArray3[i2] = this.fval[n2 + i2][n3 + n];
            }
            PolynomialSplineFunction polynomialSplineFunction = akimaSplineInterpolator.interpolate(dArray, dArray3);
            dArray4[n] = polynomialSplineFunction.value(d2);
        }
        PolynomialSplineFunction polynomialSplineFunction = akimaSplineInterpolator.interpolate(dArray2, dArray4);
        double d4 = polynomialSplineFunction.value(d3);
        return d4;
    }

    public boolean isValidPoint(double d2, double d3) {
        return !(d2 < this.xval[0] || d2 > this.xval[this.xval.length - 1] || d3 < this.yval[0]) && !(d3 > this.yval[this.yval.length - 1]);
    }

    private int searchIndex(double d2, double[] dArray, int n, int n2) {
        int n3 = Arrays.binarySearch(dArray, d2);
        if (n3 == -1 || n3 == -dArray.length - 1) {
            throw new OutOfRangeException(d2, (Number)dArray[0], dArray[dArray.length - 1]);
        }
        n3 = n3 < 0 ? -n3 - n - 1 : (n3 -= n);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 + n2 >= dArray.length) {
            n3 = dArray.length - n2;
        }
        return n3;
    }
}

