/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.InterpolatingMicrosphere;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.MicrosphereProjectionInterpolator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.MultivariateInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.UnitSphereRandomVectorGenerator;

public class MicrosphereProjectionInterpolator
implements MultivariateInterpolator {
    private final double exponent;
    private final InterpolatingMicrosphere microsphere;
    private final boolean sharedSphere;
    private final double noInterpolationTolerance;

    public MicrosphereProjectionInterpolator(int n, int n2, double d2, double d3, double d4, double d5, boolean bl, double d6) {
        this(new InterpolatingMicrosphere(n, n2, d2, d3, d4, new UnitSphereRandomVectorGenerator(n)), d5, bl, d6);
    }

    public MicrosphereProjectionInterpolator(InterpolatingMicrosphere interpolatingMicrosphere, double d2, boolean bl, double d3) {
        if (d2 < 0.0) {
            throw new NotPositiveException(d2);
        }
        this.microsphere = interpolatingMicrosphere;
        this.exponent = d2;
        this.sharedSphere = bl;
        this.noInterpolationTolerance = d3;
    }

    public MultivariateFunction interpolate(double[][] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray[0] == null) {
            throw new NullArgumentException();
        }
        int n = this.microsphere.getDimension();
        if (n != dArray[0].length) {
            throw new DimensionMismatchException(dArray[0].length, n);
        }
        InterpolatingMicrosphere interpolatingMicrosphere = this.sharedSphere ? this.microsphere : this.microsphere.copy();
        return new MicrosphereProjectionInterpolator$1(this, interpolatingMicrosphere, dArray, dArray2);
    }

    static /* synthetic */ double access$000(MicrosphereProjectionInterpolator microsphereProjectionInterpolator) {
        return microsphereProjectionInterpolator.exponent;
    }

    static /* synthetic */ double access$100(MicrosphereProjectionInterpolator microsphereProjectionInterpolator) {
        return microsphereProjectionInterpolator.noInterpolationTolerance;
    }
}

