/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.MicrosphereInterpolatingFunction$MicrosphereSurfaceElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayRealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.UnitSphereRandomVectorGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class MicrosphereInterpolatingFunction
implements MultivariateFunction {
    private final int dimension;
    private final List<MicrosphereInterpolatingFunction$MicrosphereSurfaceElement> microsphere;
    private final double brightnessExponent;
    private final Map<RealVector, Double> samples;

    public MicrosphereInterpolatingFunction(double[][] dArray, double[] dArray2, int n, int n2, UnitSphereRandomVectorGenerator unitSphereRandomVectorGenerator) {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray[0] == null) {
            throw new NullArgumentException();
        }
        this.dimension = dArray[0].length;
        this.brightnessExponent = n;
        this.samples = new HashMap<RealVector, Double>(dArray2.length);
        for (n = 0; n < dArray.length; ++n) {
            double[] dArray3 = dArray[n];
            if (dArray3 == null) {
                throw new NullArgumentException();
            }
            if (dArray3.length != this.dimension) {
                throw new DimensionMismatchException(dArray3.length, this.dimension);
            }
            this.samples.put(new ArrayRealVector(dArray3), dArray2[n]);
        }
        this.microsphere = new ArrayList<MicrosphereInterpolatingFunction$MicrosphereSurfaceElement>(n2);
        for (n = 0; n < n2; ++n) {
            this.microsphere.add(new MicrosphereInterpolatingFunction$MicrosphereSurfaceElement(unitSphereRandomVectorGenerator.nextVector()));
        }
    }

    public double value(double[] object) {
        object = new ArrayRealVector((double[])object);
        for (MicrosphereInterpolatingFunction$MicrosphereSurfaceElement object2 : this.microsphere) {
            object2.reset();
        }
        for (Map.Entry entry : this.samples.entrySet()) {
            double d2;
            RealVector realVector = ((RealVector)entry.getKey()).subtract((RealVector)object);
            double d3 = realVector.getNorm();
            if (FastMath.abs(d2) < FastMath.ulp(1.0)) {
                return (Double)entry.getValue();
            }
            for (MicrosphereInterpolatingFunction$MicrosphereSurfaceElement microsphereInterpolatingFunction$MicrosphereSurfaceElement : this.microsphere) {
                double d4 = FastMath.pow(d3, -this.brightnessExponent);
                microsphereInterpolatingFunction$MicrosphereSurfaceElement.store(this.cosAngle(realVector, microsphereInterpolatingFunction$MicrosphereSurfaceElement.normal()) * d4, entry);
            }
        }
        double d5 = 0.0;
        double d6 = 0.0;
        for (MicrosphereInterpolatingFunction$MicrosphereSurfaceElement microsphereInterpolatingFunction$MicrosphereSurfaceElement : this.microsphere) {
            double d7 = microsphereInterpolatingFunction$MicrosphereSurfaceElement.illumination();
            Map.Entry<RealVector, Double> entry = microsphereInterpolatingFunction$MicrosphereSurfaceElement.sample();
            if (entry == null) continue;
            d5 += d7 * entry.getValue();
            d6 += d7;
        }
        return d5 / d6;
    }

    private double cosAngle(RealVector realVector, RealVector realVector2) {
        return realVector.dotProduct(realVector2) / (realVector.getNorm() * realVector2.getNorm());
    }
}

