/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.util.Arrays;

public class LoessInterpolator
implements UnivariateInterpolator,
Serializable {
    public static final double DEFAULT_BANDWIDTH = 0.3;
    public static final int DEFAULT_ROBUSTNESS_ITERS = 2;
    public static final double DEFAULT_ACCURACY = 1.0E-12;
    private static final long serialVersionUID = 5204927143605193821L;
    private final double bandwidth;
    private final int robustnessIters;
    private final double accuracy;

    public LoessInterpolator() {
        this.bandwidth = 0.3;
        this.robustnessIters = 2;
        this.accuracy = 1.0E-12;
    }

    public LoessInterpolator(double d2, int n) {
        this(d2, n, 1.0E-12);
    }

    public LoessInterpolator(double d2, int n, double d3) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.BANDWIDTH, (Number)d2, 0, 1);
        }
        this.bandwidth = d2;
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.ROBUSTNESS_ITERATIONS, n);
        }
        this.robustnessIters = n;
        this.accuracy = d3;
    }

    public final PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) {
        return new SplineInterpolator().interpolate(dArray, this.smooth(dArray, dArray2));
    }

    public final double[] smooth(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        int n = dArray.length;
        if (n == 0) {
            throw new NoDataException();
        }
        LoessInterpolator.checkAllFiniteReal(dArray);
        LoessInterpolator.checkAllFiniteReal(dArray2);
        LoessInterpolator.checkAllFiniteReal(dArray3);
        MathArrays.checkOrder(dArray);
        if (n == 1) {
            return new double[]{dArray2[0]};
        }
        if (n == 2) {
            return new double[]{dArray2[0], dArray2[1]};
        }
        int n2 = (int)(this.bandwidth * (double)n);
        if (n2 < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.BANDWIDTH, (Number)n2, 2, true);
        }
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        Arrays.fill(dArray7, 1.0);
        for (int i2 = 0; i2 <= this.robustnessIters; ++i2) {
            int[] nArray = new int[]{0, n2 - 1};
            for (int i3 = 0; i3 < n; ++i3) {
                double d2;
                double d3;
                int n3;
                int n4;
                double d4 = dArray[i3];
                if (i3 > 0) {
                    LoessInterpolator.updateBandwidthInterval(dArray, dArray3, i3, nArray);
                }
                int n5 = dArray[i3] - dArray[n4 = nArray[0]] > dArray[n3 = nArray[1]] - dArray[i3] ? n4 : n3;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = FastMath.abs(1.0 / (dArray[n5] - d4));
                for (int i4 = n4; i4 <= n3; ++i4) {
                    double d11 = dArray[i4];
                    double d12 = dArray2[i4];
                    double d13 = i4 < i3 ? d4 - d11 : d11 - d4;
                    double d14 = LoessInterpolator.tricube(d13 * d10) * dArray7[i4] * dArray3[i4];
                    double d15 = d11 * d14;
                    d5 += d14;
                    d6 += d15;
                    d7 += d11 * d15;
                    d8 += d12 * d14;
                    d9 += d12 * d15;
                }
                double d16 = d6 / d5;
                double d17 = d8 / d5;
                double d18 = d9 / d5;
                double d19 = d7 / d5;
                double d20 = d16;
                if (FastMath.sqrt(FastMath.abs(d3 - d20 * d20)) < this.accuracy) {
                    d2 = 0.0;
                } else {
                    double d21 = d16;
                    d2 = (d18 - d16 * d17) / (d19 - d21 * d21);
                }
                double d22 = d17 - d2 * d16;
                dArray4[i3] = d2 * d4 + d22;
                dArray5[i3] = FastMath.abs(dArray2[i3] - dArray4[i3]);
            }
            if (i2 == this.robustnessIters) break;
            System.arraycopy(dArray5, 0, dArray6, 0, n);
            Arrays.sort(dArray6);
            double d23 = dArray6[n / 2];
            if (FastMath.abs(d23) < this.accuracy) break;
            for (int i5 = 0; i5 < n; ++i5) {
                double d24;
                double d25;
                double d26 = dArray5[i5] / (d23 * 6.0);
                if (d25 >= 1.0) {
                    dArray7[i5] = 0.0;
                    continue;
                }
                double d27 = d26;
                double d28 = d24 = 1.0 - d27 * d27;
                dArray7[i5] = d28 * d28;
            }
        }
        return dArray4;
    }

    public final double[] smooth(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        double[] dArray3 = new double[dArray.length];
        Arrays.fill(dArray3, 1.0);
        return this.smooth(dArray, dArray2, dArray3);
    }

    private static void updateBandwidthInterval(double[] dArray, double[] dArray2, int n, int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        if ((n3 = LoessInterpolator.nextNonzero(dArray2, n3)) < dArray.length && dArray[n3] - dArray[n] < dArray[n] - dArray[n2]) {
            int n4;
            nArray[0] = n4 = LoessInterpolator.nextNonzero(dArray2, nArray[0]);
            nArray[1] = n3;
        }
    }

    private static int nextNonzero(double[] dArray, int n) {
        ++n;
        while (n < dArray.length && dArray[n] == 0.0) {
            ++n;
        }
        return n;
    }

    private static double tricube(double d2) {
        double d3;
        double d4 = FastMath.abs(d2);
        if (d3 >= 1.0) {
            return 0.0;
        }
        double d5 = d4;
        double d6 = 1.0 - d5 * d5 * d4;
        return d6 * d6 * d6;
    }

    private static void checkAllFiniteReal(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            MathUtils.checkFinite(dArray[i2]);
        }
    }
}

