/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class LinearInterpolator
implements UnivariateInterpolator {
    public PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 2, true);
        }
        int n = dArray.length - 1;
        MathArrays.checkOrder(dArray);
        double[] dArray3 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray3[i2] = (dArray2[i2 + 1] - dArray2[i2]) / (dArray[i2 + 1] - dArray[i2]);
        }
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n];
        double[] dArray4 = new double[2];
        for (int i3 = 0; i3 < n; ++i3) {
            dArray4[0] = dArray2[i3];
            dArray4[1] = dArray3[i3];
            polynomialFunctionArray[i3] = new PolynomialFunction(dArray4);
        }
        return new PolynomialSplineFunction(dArray, polynomialFunctionArray);
    }
}

