/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.InterpolatingMicrosphere$Facet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.InterpolatingMicrosphere$FacetData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MaxCountExceededException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.UnitSphereRandomVectorGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.ArrayList;
import java.util.List;

public class InterpolatingMicrosphere {
    private final List<InterpolatingMicrosphere$Facet> microsphere;
    private final List<InterpolatingMicrosphere$FacetData> microsphereData;
    private final int dimension;
    private final int size;
    private final double maxDarkFraction;
    private final double darkThreshold;
    private final double background;

    protected InterpolatingMicrosphere(int n, int n2, double d2, double d3, double d4) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException(n2);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        if (d3 < 0.0) {
            throw new NotPositiveException(d3);
        }
        this.dimension = n;
        this.size = n2;
        this.maxDarkFraction = d2;
        this.darkThreshold = d3;
        this.background = d4;
        this.microsphere = new ArrayList<InterpolatingMicrosphere$Facet>(n2);
        this.microsphereData = new ArrayList<InterpolatingMicrosphere$FacetData>(n2);
    }

    public InterpolatingMicrosphere(int n, int n2, double d2, double d3, double d4, UnitSphereRandomVectorGenerator unitSphereRandomVectorGenerator) {
        this(n, n2, d2, d3, d4);
        for (n = 0; n < n2; ++n) {
            this.add(unitSphereRandomVectorGenerator.nextVector(), false);
        }
    }

    protected InterpolatingMicrosphere(InterpolatingMicrosphere object) {
        this.dimension = ((InterpolatingMicrosphere)object).dimension;
        this.size = ((InterpolatingMicrosphere)object).size;
        this.maxDarkFraction = ((InterpolatingMicrosphere)object).maxDarkFraction;
        this.darkThreshold = ((InterpolatingMicrosphere)object).darkThreshold;
        this.background = ((InterpolatingMicrosphere)object).background;
        this.microsphere = ((InterpolatingMicrosphere)object).microsphere;
        this.microsphereData = new ArrayList<InterpolatingMicrosphere$FacetData>(this.size);
        for (InterpolatingMicrosphere$FacetData interpolatingMicrosphere$FacetData : ((InterpolatingMicrosphere)object).microsphereData) {
            this.microsphereData.add(new InterpolatingMicrosphere$FacetData(interpolatingMicrosphere$FacetData.illumination(), interpolatingMicrosphere$FacetData.sample()));
        }
    }

    public InterpolatingMicrosphere copy() {
        return new InterpolatingMicrosphere(this);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSize() {
        return this.size;
    }

    public double value(double[] dArray, double[][] dArray2, double[] dArray3, double d2, double d3) {
        if (d2 < 0.0) {
            throw new NotPositiveException(d2);
        }
        this.clear();
        int n = dArray2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double d4;
            double[] dArray4 = MathArrays.ebeSubtract(dArray2[i2], dArray);
            double d5 = MathArrays.safeNorm(dArray4);
            if (FastMath.abs(d4) < d3) {
                return dArray3[i2];
            }
            double d6 = FastMath.pow(d5, -d2);
            this.illuminate(dArray4, dArray3[i2], d6);
        }
        return this.interpolate();
    }

    protected void add(double[] dArray, boolean bl) {
        if (this.microsphere.size() >= this.size) {
            throw new MaxCountExceededException(this.size);
        }
        if (dArray.length > this.dimension) {
            throw new DimensionMismatchException(dArray.length, this.dimension);
        }
        this.microsphere.add(new InterpolatingMicrosphere$Facet(bl ? (double[])dArray.clone() : dArray));
        this.microsphereData.add(new InterpolatingMicrosphere$FacetData(0.0, 0.0));
    }

    private double interpolate() {
        double d2;
        int n = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (InterpolatingMicrosphere$FacetData interpolatingMicrosphere$FacetData : this.microsphereData) {
            double d5 = interpolatingMicrosphere$FacetData.illumination();
            if (d5 != 0.0) {
                d3 += d5 * interpolatingMicrosphere$FacetData.sample();
                d4 += d5;
                continue;
            }
            ++n;
        }
        double d6 = (double)n / (double)this.size;
        if (d2 <= this.maxDarkFraction) {
            return d3 / d4;
        }
        return this.background;
    }

    private void illuminate(double[] dArray, double d2, double d3) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            double d4;
            double d5;
            double[] dArray2 = this.microsphere.get(i2).getNormal();
            double d6 = MathArrays.cosAngle(dArray2, dArray);
            if (!(d5 > 0.0)) continue;
            double d7 = d6 * d3;
            if (!(d4 > this.darkThreshold) || !(d7 > this.microsphereData.get(i2).illumination())) continue;
            this.microsphereData.set(i2, new InterpolatingMicrosphere$FacetData(d7, d2));
        }
    }

    private void clear() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.microsphereData.set(i2, new InterpolatingMicrosphere$FacetData(0.0, 0.0));
        }
    }
}

