/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HermiteInterpolator
implements UnivariateDifferentiableVectorFunction {
    private final List<Double> abscissae = new ArrayList<Double>();
    private final List<double[]> topDiagonal = new ArrayList<double[]>();
    private final List<double[]> bottomDiagonal = new ArrayList<double[]>();

    public void addSamplePoint(double d2, double[] ... dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n;
            double[] dArray2 = (double[])dArray[i2].clone();
            if (i2 > 1) {
                double d3 = 1.0 / (double)CombinatoricsUtils.factorial(i2);
                n = 0;
                while (n < dArray2.length) {
                    int n2 = n++;
                    dArray2[n2] = dArray2[n2] * d3;
                }
            }
            int n3 = this.abscissae.size();
            this.bottomDiagonal.add(n3 - i2, dArray2);
            double[] dArray3 = dArray2;
            for (n = i2; n < n3; ++n) {
                double[] dArray4 = this.bottomDiagonal.get(n3 - (n + 1));
                double d4 = 1.0 / (d2 - this.abscissae.get(n3 - (n + 1)));
                if (Double.isInfinite(d4)) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, d2);
                }
                for (int i3 = 0; i3 < dArray2.length; ++i3) {
                    dArray4[i3] = d4 * (dArray3[i3] - dArray4[i3]);
                }
                dArray3 = dArray4;
            }
            this.topDiagonal.add((double[])dArray3.clone());
            this.abscissae.add(d2);
        }
    }

    public PolynomialFunction[] getPolynomials() {
        this.checkInterpolation();
        PolynomialFunction polynomialFunction = this.polynomial(0.0);
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[this.topDiagonal.get(0).length];
        for (int i2 = 0; i2 < polynomialFunctionArray.length; ++i2) {
            polynomialFunctionArray[i2] = polynomialFunction;
        }
        PolynomialFunction polynomialFunction2 = this.polynomial(1.0);
        for (int i3 = 0; i3 < this.topDiagonal.size(); ++i3) {
            double[] dArray = this.topDiagonal.get(i3);
            for (int i4 = 0; i4 < polynomialFunctionArray.length; ++i4) {
                polynomialFunctionArray[i4] = polynomialFunctionArray[i4].add(polynomialFunction2.multiply(this.polynomial(dArray[i4])));
            }
            polynomialFunction2 = polynomialFunction2.multiply(this.polynomial(-this.abscissae.get(i3).doubleValue(), 1.0));
        }
        return polynomialFunctionArray;
    }

    public double[] value(double d2) {
        this.checkInterpolation();
        double[] dArray = new double[this.topDiagonal.get(0).length];
        double d3 = 1.0;
        for (int i2 = 0; i2 < this.topDiagonal.size(); ++i2) {
            double[] dArray2 = this.topDiagonal.get(i2);
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                int n = i3;
                dArray[n] = dArray[n] + dArray2[i3] * d3;
            }
            double d4 = d2 - this.abscissae.get(i2);
            d3 *= d4;
        }
        return dArray;
    }

    public DerivativeStructure[] value(DerivativeStructure derivativeStructure) {
        this.checkInterpolation();
        Object[] objectArray = new DerivativeStructure[this.topDiagonal.get(0).length];
        Arrays.fill(objectArray, derivativeStructure.getField().getZero());
        DerivativeStructure derivativeStructure2 = derivativeStructure.getField().getOne();
        for (int i2 = 0; i2 < this.topDiagonal.size(); ++i2) {
            double[] dArray = this.topDiagonal.get(i2);
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                objectArray[i3] = ((DerivativeStructure)objectArray[i3]).add(derivativeStructure2.multiply(dArray[i3]));
            }
            DerivativeStructure derivativeStructure3 = derivativeStructure.subtract(this.abscissae.get(i2));
            derivativeStructure2 = derivativeStructure2.multiply(derivativeStructure3);
        }
        return objectArray;
    }

    private void checkInterpolation() {
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
    }

    private PolynomialFunction polynomial(double ... dArray) {
        return new PolynomialFunction(dArray);
    }
}

