/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldHermiteInterpolator<T extends FieldElement<T>> {
    private final List<T> abscissae = new ArrayList<T>();
    private final List<T[]> topDiagonal = new ArrayList<T[]>();
    private final List<T[]> bottomDiagonal = new ArrayList<T[]>();

    public void addSamplePoint(T t, T[] ... TArray) {
        MathUtils.checkNotNull(t);
        FieldElement fieldElement = (FieldElement)t.getField().getOne();
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            FieldElement[] fieldElementArray = (FieldElement[])TArray[i2].clone();
            if (i2 > 1) {
                fieldElement = (FieldElement)fieldElement.multiply(i2);
                FieldElement fieldElement2 = (FieldElement)fieldElement.reciprocal();
                for (int i3 = 0; i3 < fieldElementArray.length; ++i3) {
                    fieldElementArray[i3] = fieldElementArray[i3].multiply(fieldElement2);
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i2, fieldElementArray);
            FieldElement[] fieldElementArray2 = fieldElementArray;
            for (int i4 = i2; i4 < n; ++i4) {
                FieldElement[] fieldElementArray3 = (FieldElement[])this.bottomDiagonal.get(n - (i4 + 1));
                if (t.equals(this.abscissae.get(n - (i4 + 1)))) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, t);
                }
                FieldElement fieldElement3 = (FieldElement)((FieldElement)t.subtract(this.abscissae.get(n - (i4 + 1)))).reciprocal();
                for (int i5 = 0; i5 < fieldElementArray.length; ++i5) {
                    fieldElementArray3[i5] = fieldElement3.multiply(fieldElementArray2[i5].subtract(fieldElementArray3[i5]));
                }
                fieldElementArray2 = fieldElementArray3;
            }
            this.topDiagonal.add((T[])fieldElementArray2.clone());
            this.abscissae.add(t);
        }
    }

    public T[] value(T t) {
        MathUtils.checkNotNull(t);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(t.getField(), ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement fieldElement = (FieldElement)t.getField().getOne();
        for (int i2 = 0; i2 < this.topDiagonal.size(); ++i2) {
            FieldElement[] fieldElementArray2 = (FieldElement[])this.topDiagonal.get(i2);
            for (int i3 = 0; i3 < fieldElementArray.length; ++i3) {
                fieldElementArray[i3] = fieldElementArray[i3].add(fieldElementArray2[i3].multiply(fieldElement));
            }
            FieldElement fieldElement2 = (FieldElement)t.subtract(this.abscissae.get(i2));
            fieldElement = fieldElement.multiply(fieldElement2);
        }
        return fieldElementArray;
    }

    public T[][] derivatives(T t, int n) {
        MathUtils.checkNotNull(t);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement fieldElement = (FieldElement)t.getField().getZero();
        FieldElement[] fieldElementArray = (FieldElement[])t.getField().getOne();
        FieldElement[] fieldElementArray2 = (FieldElement[])MathArrays.buildArray(t.getField(), n + 1);
        FieldElement[] fieldElementArray3 = fieldElementArray2;
        fieldElementArray2[0] = fieldElement;
        for (int i2 = 0; i2 < n; ++i2) {
            fieldElementArray3[i2 + 1] = fieldElementArray3[i2].add(fieldElementArray);
        }
        FieldElement[][] fieldElementArray4 = (FieldElement[][])MathArrays.buildArray(t.getField(), n + 1, ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement[] fieldElementArray5 = (FieldElement[])MathArrays.buildArray(t.getField(), n + 1);
        fieldElementArray = fieldElementArray5;
        fieldElementArray5[0] = (FieldElement)t.getField().getOne();
        for (int i3 = 0; i3 < this.topDiagonal.size(); ++i3) {
            FieldElement[] fieldElementArray6 = (FieldElement[])this.topDiagonal.get(i3);
            FieldElement fieldElement2 = (FieldElement)t.subtract(this.abscissae.get(i3));
            for (int i4 = n; i4 >= 0; --i4) {
                for (int i5 = 0; i5 < fieldElementArray4[i4].length; ++i5) {
                    fieldElementArray4[i4][i5] = fieldElementArray4[i4][i5].add(fieldElementArray6[i5].multiply(fieldElementArray[i4]));
                }
                fieldElementArray[i4] = fieldElementArray[i4].multiply(fieldElement2);
                if (i4 <= 0) continue;
                fieldElementArray[i4] = fieldElementArray[i4].add(fieldElementArray3[i4].multiply(fieldElementArray[i4 - 1]));
            }
        }
        return fieldElementArray4;
    }
}

