/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.BivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicSplineFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Arrays;

@Deprecated
public class BicubicSplineInterpolatingFunction
implements BivariateFunction {
    private static final int NUM_COEFF = 16;
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicSplineFunction[][] splines;
    private final BivariateFunction[][][] partialDerivatives;

    public BicubicSplineInterpolatingFunction(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        this(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, false);
    }

    public BicubicSplineInterpolatingFunction(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6, boolean bl) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray2.length;
        if (n2 == 0 || n3 == 0 || dArray3.length == 0 || dArray3[0].length == 0) {
            throw new NoDataException();
        }
        if (n2 != dArray3.length) {
            throw new DimensionMismatchException(n2, dArray3.length);
        }
        if (n2 != dArray4.length) {
            throw new DimensionMismatchException(n2, dArray4.length);
        }
        if (n2 != dArray5.length) {
            throw new DimensionMismatchException(n2, dArray5.length);
        }
        if (n2 != dArray6.length) {
            throw new DimensionMismatchException(n2, dArray6.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        this.xval = (double[])dArray.clone();
        this.yval = (double[])dArray2.clone();
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        this.splines = new BicubicSplineFunction[n4][n5];
        for (n2 = 0; n2 < n4; ++n2) {
            if (dArray3[n2].length != n3) {
                throw new DimensionMismatchException(dArray3[n2].length, n3);
            }
            if (dArray4[n2].length != n3) {
                throw new DimensionMismatchException(dArray4[n2].length, n3);
            }
            if (dArray5[n2].length != n3) {
                throw new DimensionMismatchException(dArray5[n2].length, n3);
            }
            if (dArray6[n2].length != n3) {
                throw new DimensionMismatchException(dArray6[n2].length, n3);
            }
            n = n2 + 1;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = i2 + 1;
                double[] dArray7 = new double[]{dArray3[n2][i2], dArray3[n][i2], dArray3[n2][n6], dArray3[n][n6], dArray4[n2][i2], dArray4[n][i2], dArray4[n2][n6], dArray4[n][n6], dArray5[n2][i2], dArray5[n][i2], dArray5[n2][n6], dArray5[n][n6], dArray6[n2][i2], dArray6[n][i2], dArray6[n2][n6], dArray6[n][n6]};
                this.splines[n2][i2] = new BicubicSplineFunction(this.computeSplineCoefficients(dArray7), bl);
            }
        }
        if (bl) {
            this.partialDerivatives = new BivariateFunction[5][n4][n5];
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n5; ++n) {
                    BicubicSplineFunction bicubicSplineFunction = this.splines[n2][n];
                    this.partialDerivatives[0][n2][n] = bicubicSplineFunction.partialDerivativeX();
                    this.partialDerivatives[1][n2][n] = bicubicSplineFunction.partialDerivativeY();
                    this.partialDerivatives[2][n2][n] = bicubicSplineFunction.partialDerivativeXX();
                    this.partialDerivatives[3][n2][n] = bicubicSplineFunction.partialDerivativeYY();
                    this.partialDerivatives[4][n2][n] = bicubicSplineFunction.partialDerivativeXY();
                }
            }
            return;
        }
        this.partialDerivatives = null;
    }

    public double value(double d2, double d3) {
        int n = this.searchIndex(d2, this.xval);
        int n2 = this.searchIndex(d3, this.yval);
        double d4 = (d2 - this.xval[n]) / (this.xval[n + 1] - this.xval[n]);
        double d5 = (d3 - this.yval[n2]) / (this.yval[n2 + 1] - this.yval[n2]);
        return this.splines[n][n2].value(d4, d5);
    }

    public boolean isValidPoint(double d2, double d3) {
        return !(d2 < this.xval[0] || d2 > this.xval[this.xval.length - 1] || d3 < this.yval[0]) && !(d3 > this.yval[this.yval.length - 1]);
    }

    public double partialDerivativeX(double d2, double d3) {
        return this.partialDerivative(0, d2, d3);
    }

    public double partialDerivativeY(double d2, double d3) {
        return this.partialDerivative(1, d2, d3);
    }

    public double partialDerivativeXX(double d2, double d3) {
        return this.partialDerivative(2, d2, d3);
    }

    public double partialDerivativeYY(double d2, double d3) {
        return this.partialDerivative(3, d2, d3);
    }

    public double partialDerivativeXY(double d2, double d3) {
        return this.partialDerivative(4, d2, d3);
    }

    private double partialDerivative(int n, double d2, double d3) {
        int n2 = this.searchIndex(d2, this.xval);
        int n3 = this.searchIndex(d3, this.yval);
        double d4 = (d2 - this.xval[n2]) / (this.xval[n2 + 1] - this.xval[n2]);
        double d5 = (d3 - this.yval[n3]) / (this.yval[n3 + 1] - this.yval[n3]);
        return this.partialDerivatives[n][n2][n3].value(d4, d5);
    }

    private int searchIndex(double d2, double[] dArray) {
        int n = Arrays.binarySearch(dArray, d2);
        if (n == -1 || n == -dArray.length - 1) {
            throw new OutOfRangeException(d2, (Number)dArray[0], dArray[dArray.length - 1]);
        }
        if (n < 0) {
            return -n - 2;
        }
        int n2 = dArray.length - 1;
        if (n == n2) {
            return n2 - 1;
        }
        return n;
    }

    private double[] computeSplineCoefficients(double[] dArray) {
        double[] dArray2 = new double[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            double d2 = 0.0;
            double[] dArray3 = AINV[i2];
            for (int i3 = 0; i3 < 16; ++i3) {
                d2 += dArray3[i3] * dArray[i3];
            }
            dArray2[i2] = d2;
        }
        return dArray2;
    }
}

