/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.BivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicSplineFunction$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicSplineFunction$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicSplineFunction$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicSplineFunction$4;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicSplineFunction$5;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;

class BicubicSplineFunction
implements BivariateFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];
    private final BivariateFunction partialDerivativeX;
    private final BivariateFunction partialDerivativeY;
    private final BivariateFunction partialDerivativeXX;
    private final BivariateFunction partialDerivativeYY;
    private final BivariateFunction partialDerivativeXY;

    BicubicSplineFunction(double[] dArray) {
        this(dArray, false);
    }

    BicubicSplineFunction(double[] object, boolean bl) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                this.a[i2][i3] = object[(i2 << 2) + i3];
            }
        }
        if (bl) {
            double[][] dArray = new double[4][4];
            double[][] dArray2 = new double[4][4];
            object = new double[4][4];
            double[][] dArray3 = new double[4][4];
            double[][] dArray4 = new double[4][4];
            for (int i4 = 0; i4 < 4; ++i4) {
                for (int i5 = 0; i5 < 4; ++i5) {
                    double d2 = this.a[i4][i5];
                    dArray[i4][i5] = (double)i4 * d2;
                    int n = i5;
                    dArray2[i4][n] = (double)n * d2;
                    object[i4][i5] = (double)(i4 - 1) * dArray[i4][i5];
                    int n2 = i5;
                    dArray3[i4][n2] = (double)(n2 - 1) * dArray2[i4][i5];
                    int n3 = i5;
                    dArray4[i4][n3] = (double)n3 * dArray[i4][i5];
                }
            }
            this.partialDerivativeX = new BicubicSplineFunction$1(this, dArray);
            this.partialDerivativeY = new BicubicSplineFunction$2(this, dArray2);
            this.partialDerivativeXX = new BicubicSplineFunction$3(this, (double[][])object);
            this.partialDerivativeYY = new BicubicSplineFunction$4(this, dArray3);
            this.partialDerivativeXY = new BicubicSplineFunction$5(this, dArray4);
            return;
        }
        this.partialDerivativeX = null;
        this.partialDerivativeY = null;
        this.partialDerivativeXX = null;
        this.partialDerivativeYY = null;
        this.partialDerivativeXY = null;
    }

    public double value(double d2, double d3) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new OutOfRangeException(d3, (Number)0, 1);
        }
        double d4 = d2;
        double d5 = d4 * d4;
        double d6 = d5 * d2;
        double[] dArray = new double[]{1.0, d2, d5, d6};
        double d7 = d3;
        double d8 = d7 * d7;
        double d9 = d8 * d3;
        double[] dArray2 = new double[]{1.0, d3, d8, d9};
        return this.apply(dArray, dArray2, this.a);
    }

    private double apply(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                d2 += dArray3[i2][i3] * dArray[i2] * dArray2[i3];
            }
        }
        return d2;
    }

    public BivariateFunction partialDerivativeX() {
        return this.partialDerivativeX;
    }

    public BivariateFunction partialDerivativeY() {
        return this.partialDerivativeY;
    }

    public BivariateFunction partialDerivativeXX() {
        return this.partialDerivativeXX;
    }

    public BivariateFunction partialDerivativeYY() {
        return this.partialDerivativeYY;
    }

    public BivariateFunction partialDerivativeXY() {
        return this.partialDerivativeXY;
    }

    static /* synthetic */ double access$000(BicubicSplineFunction bicubicSplineFunction, double[] dArray, double[] dArray2, double[][] dArray3) {
        return bicubicSplineFunction.apply(dArray, dArray2, dArray3);
    }
}

