/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicInterpolatingFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BicubicInterpolator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class BicubicInterpolator
implements BivariateGridInterpolator {
    public BicubicInterpolatingFunction interpolate(double[] dArray, double[] dArray2, double[][] dArray3) {
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        double[][] dArray4 = new double[n][n2];
        double[][] dArray5 = new double[n][n2];
        double[][] dArray6 = new double[n][n2];
        for (int i2 = 1; i2 < n - 1; ++i2) {
            int n3 = i2 + 1;
            int n4 = i2 - 1;
            double d2 = dArray[n3];
            double d3 = dArray[n4];
            double d4 = d2 - d3;
            for (int i3 = 1; i3 < n2 - 1; ++i3) {
                int n5 = i3 + 1;
                int n6 = i3 - 1;
                double d5 = dArray2[n5];
                double d6 = dArray2[n6];
                double d7 = d5 - d6;
                dArray4[i2][i3] = (dArray3[n3][i3] - dArray3[n4][i3]) / d4;
                dArray5[i2][i3] = (dArray3[i2][n5] - dArray3[i2][n6]) / d7;
                double d8 = d4 * d7;
                dArray6[i2][i3] = (dArray3[n3][n5] - dArray3[n3][n6] - dArray3[n4][n5] + dArray3[n4][n6]) / d8;
            }
        }
        return new BicubicInterpolator$1(this, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray, dArray2);
    }
}

