/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

public class AkimaSplineInterpolator
implements UnivariateInterpolator {
    private static final int MINIMUM_NUMBER_POINTS = 5;

    public PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) {
        int n;
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 5) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 5, true);
        }
        MathArrays.checkOrder(dArray);
        int n2 = dArray.length - 1;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = (dArray2[n + 1] - dArray2[n]) / (dArray[n + 1] - dArray[n]);
        }
        for (n = 1; n < dArray4.length; ++n) {
            dArray4[n] = FastMath.abs(dArray3[n] - dArray3[n - 1]);
        }
        double[] dArray5 = new double[dArray.length];
        for (int i2 = 2; i2 < dArray5.length - 2; ++i2) {
            double d2 = dArray4[i2 + 1];
            double d3 = dArray4[i2 - 1];
            if (Precision.equals(d2, 0.0) && Precision.equals(d3, 0.0)) {
                double d4 = dArray[i2];
                double d5 = dArray[i2 + 1];
                double d6 = dArray[i2 - 1];
                dArray5[i2] = ((d5 - d4) * dArray3[i2 - 1] + (d4 - d6) * dArray3[i2]) / (d5 - d6);
                continue;
            }
            dArray5[i2] = (d2 * dArray3[i2 - 1] + d3 * dArray3[i2]) / (d2 + d3);
        }
        dArray5[0] = this.differentiateThreePoint(dArray, dArray2, 0, 0, 1, 2);
        dArray5[1] = this.differentiateThreePoint(dArray, dArray2, 1, 0, 1, 2);
        dArray5[dArray.length - 2] = this.differentiateThreePoint(dArray, dArray2, dArray.length - 2, dArray.length - 3, dArray.length - 2, dArray.length - 1);
        dArray5[dArray.length - 1] = this.differentiateThreePoint(dArray, dArray2, dArray.length - 1, dArray.length - 3, dArray.length - 2, dArray.length - 1);
        return this.interpolateHermiteSorted(dArray, dArray2, dArray5);
    }

    private double differentiateThreePoint(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        double d2;
        double d3 = dArray2[n2];
        double d4 = dArray2[n3];
        double d5 = dArray2[n4];
        double d6 = dArray[n] - dArray[n2];
        double d7 = dArray[n3] - dArray[n2];
        double d8 = d2 = dArray[n4] - dArray[n2];
        double d9 = (d5 - d3 - d2 / d7 * (d4 - d3)) / (d8 * d8 - d7 * d2);
        double d10 = (d4 - d3 - d9 * d7 * d7) / d7;
        return d9 * 2.0 * d6 + d10;
    }

    private PolynomialSplineFunction interpolateHermiteSorted(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 2, true);
        }
        int n = dArray.length - 1;
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n];
        double[] dArray4 = new double[4];
        for (int i2 = 0; i2 < polynomialFunctionArray.length; ++i2) {
            double d2 = dArray[i2 + 1] - dArray[i2];
            double d3 = d2 * d2;
            double d4 = dArray2[i2];
            double d5 = dArray2[i2 + 1];
            double d6 = dArray3[i2];
            double d7 = dArray3[i2 + 1];
            dArray4[0] = d4;
            dArray4[1] = dArray3[i2];
            dArray4[2] = (3.0 * (d5 - d4) / d2 - d6 * 2.0 - d7) / d2;
            dArray4[3] = (2.0 * (d4 - d5) / d2 + d6 + d7) / d3;
            polynomialFunctionArray[i2] = new PolynomialFunction(dArray4);
        }
        return new PolynomialSplineFunction(dArray, polynomialFunctionArray);
    }
}

