/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricGaussIntegrator
extends GaussIntegrator {
    public SymmetricGaussIntegrator(double[] dArray, double[] dArray2) {
        super(dArray, dArray2);
    }

    public SymmetricGaussIntegrator(Pair<double[], double[]> pair) {
        this(pair.getFirst(), pair.getSecond());
    }

    @Override
    public double integrate(UnivariateFunction univariateFunction) {
        int n = this.getNumberOfPoints();
        if (n == 1) {
            return this.getWeight(0) * univariateFunction.value(0.0);
        }
        int n2 = n / 2;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = this.getPoint(i2);
            double d5 = this.getWeight(i2);
            double d6 = univariateFunction.value(d4);
            double d7 = univariateFunction.value(-d4);
            double d8 = d5 * (d6 + d7) - d3;
            double d9 = d2 + d8;
            d3 = d9 - d2 - d8;
            d2 = d9;
        }
        if (n % 2 != 0) {
            double d10;
            double d11 = this.getWeight(n2);
            double d12 = d11 * univariateFunction.value(0.0) - d3;
            d2 = d10 = d2 + d12;
        }
        return d2;
    }
}

