/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.math.BigDecimal;
import java.math.MathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendreHighPrecisionRuleFactory
extends BaseRuleFactory<BigDecimal> {
    private final MathContext mContext;
    private final BigDecimal two;
    private final BigDecimal minusOne;
    private final BigDecimal oneHalf;

    public LegendreHighPrecisionRuleFactory() {
        this(MathContext.DECIMAL128);
    }

    public LegendreHighPrecisionRuleFactory(MathContext mathContext) {
        this.mContext = mathContext;
        this.two = new BigDecimal("2", mathContext);
        this.minusOne = new BigDecimal("-1", mathContext);
        this.oneHalf = new BigDecimal("0.5", mathContext);
    }

    @Override
    protected Pair<BigDecimal[], BigDecimal[]> computeRule(int n) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        if (n == 1) {
            return new Pair<BigDecimal[], BigDecimal[]>(new BigDecimal[]{BigDecimal.ZERO}, new BigDecimal[]{this.two});
        }
        BigDecimal[] bigDecimalArray = (BigDecimal[])this.getRuleInternal(n - 1).getFirst();
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n];
        BigDecimal[] bigDecimalArray3 = new BigDecimal[n];
        int n2 = n / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4;
            BigDecimal bigDecimal5;
            BigDecimal bigDecimal6;
            BigDecimal bigDecimal7 = i2 == 0 ? this.minusOne : bigDecimalArray[i2 - 1];
            bigDecimal2 = n2 == 1 ? BigDecimal.ONE : bigDecimalArray[i2];
            bigDecimal = BigDecimal.ONE;
            BigDecimal bigDecimal8 = bigDecimal7;
            BigDecimal bigDecimal9 = BigDecimal.ONE;
            BigDecimal bigDecimal10 = bigDecimal2;
            for (int i3 = 1; i3 < n; ++i3) {
                bigDecimal6 = new BigDecimal(2 * i3 + 1, this.mContext);
                bigDecimal5 = new BigDecimal(i3, this.mContext);
                BigDecimal bigDecimal11 = new BigDecimal(i3 + 1, this.mContext);
                bigDecimal4 = bigDecimal7.multiply(bigDecimal6, this.mContext);
                bigDecimal4 = bigDecimal8.multiply(bigDecimal4, this.mContext);
                bigDecimal = bigDecimal.multiply(bigDecimal5, this.mContext);
                bigDecimal3 = bigDecimal4.subtract(bigDecimal, this.mContext);
                bigDecimal3 = bigDecimal3.divide(bigDecimal11, this.mContext);
                bigDecimal4 = bigDecimal2.multiply(bigDecimal6, this.mContext);
                bigDecimal4 = bigDecimal10.multiply(bigDecimal4, this.mContext);
                bigDecimal = bigDecimal9.multiply(bigDecimal5, this.mContext);
                bigDecimal4 = bigDecimal4.subtract(bigDecimal, this.mContext);
                bigDecimal4 = bigDecimal4.divide(bigDecimal11, this.mContext);
                bigDecimal = bigDecimal8;
                bigDecimal8 = bigDecimal3;
                bigDecimal9 = bigDecimal10;
                bigDecimal10 = bigDecimal4;
            }
            BigDecimal bigDecimal12 = bigDecimal7.add(bigDecimal2, this.mContext).multiply(this.oneHalf, this.mContext);
            bigDecimal6 = BigDecimal.ONE;
            bigDecimal5 = bigDecimal12;
            boolean bl = false;
            while (!bl) {
                bigDecimal4 = bigDecimal2.subtract(bigDecimal7, this.mContext);
                bl = bigDecimal4.compareTo(bigDecimal = bigDecimal12.ulp().multiply(BigDecimal.TEN, this.mContext)) <= 0;
                bigDecimal6 = BigDecimal.ONE;
                bigDecimal5 = bigDecimal12;
                for (int i4 = 1; i4 < n; ++i4) {
                    bigDecimal4 = new BigDecimal(2 * i4 + 1, this.mContext);
                    bigDecimal = new BigDecimal(i4, this.mContext);
                    bigDecimal9 = new BigDecimal(i4 + 1, this.mContext);
                    bigDecimal4 = bigDecimal12.multiply(bigDecimal4, this.mContext);
                    bigDecimal4 = bigDecimal5.multiply(bigDecimal4, this.mContext);
                    bigDecimal = bigDecimal6.multiply(bigDecimal, this.mContext);
                    bigDecimal = bigDecimal4.subtract(bigDecimal, this.mContext);
                    bigDecimal = bigDecimal.divide(bigDecimal9, this.mContext);
                    bigDecimal6 = bigDecimal5;
                    bigDecimal5 = bigDecimal;
                }
                if (bl) continue;
                if (bigDecimal8.signum() * bigDecimal5.signum() <= 0) {
                    bigDecimal2 = bigDecimal12;
                } else {
                    bigDecimal7 = bigDecimal12;
                    bigDecimal8 = bigDecimal5;
                }
                bigDecimal12 = bigDecimal7.add(bigDecimal2, this.mContext).multiply(this.oneHalf, this.mContext);
            }
            bigDecimal4 = new BigDecimal(n, this.mContext);
            bigDecimal = bigDecimal6.subtract(bigDecimal12.multiply(bigDecimal5, this.mContext), this.mContext);
            bigDecimal = bigDecimal.multiply(bigDecimal4);
            bigDecimal = bigDecimal.pow(2, this.mContext);
            bigDecimal3 = bigDecimal12.pow(2, this.mContext);
            bigDecimal3 = BigDecimal.ONE.subtract(bigDecimal3, this.mContext);
            bigDecimal3 = bigDecimal3.multiply(this.two, this.mContext);
            bigDecimal3 = bigDecimal3.divide(bigDecimal, this.mContext);
            bigDecimalArray2[i2] = bigDecimal12;
            bigDecimalArray3[i2] = bigDecimal3;
            int n3 = n - i2 - 1;
            bigDecimalArray2[n3] = bigDecimal12.negate(this.mContext);
            bigDecimalArray3[n3] = bigDecimal3;
        }
        if (n % 2 != 0) {
            BigDecimal bigDecimal13 = BigDecimal.ONE;
            for (int i5 = 1; i5 < n; i5 += 2) {
                bigDecimal2 = new BigDecimal(i5, this.mContext);
                bigDecimal = new BigDecimal(i5 + 1, this.mContext);
                bigDecimal13 = bigDecimal13.multiply(bigDecimal2, this.mContext);
                bigDecimal13 = bigDecimal13.divide(bigDecimal, this.mContext);
                bigDecimal13 = bigDecimal13.negate(this.mContext);
            }
            BigDecimal bigDecimal14 = new BigDecimal(n, this.mContext);
            bigDecimal2 = bigDecimal13.multiply(bigDecimal14, this.mContext);
            bigDecimal2 = bigDecimal2.pow(2, this.mContext);
            bigDecimal = this.two.divide(bigDecimal2, this.mContext);
            bigDecimalArray2[n2] = BigDecimal.ZERO;
            bigDecimalArray3[n2] = bigDecimal;
        }
        return new Pair<BigDecimal[], BigDecimal[]>(bigDecimalArray2, bigDecimalArray3);
    }
}

