/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.HermiteRuleFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.LegendreHighPrecisionRuleFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.LegendreRuleFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.SymmetricGaussIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussIntegratorFactory {
    private final BaseRuleFactory<Double> legendre = new LegendreRuleFactory();
    private final BaseRuleFactory<BigDecimal> legendreHighPrecision = new LegendreHighPrecisionRuleFactory();
    private final BaseRuleFactory<Double> hermite = new HermiteRuleFactory();

    public GaussIntegrator legendre(int n) {
        return new GaussIntegrator(GaussIntegratorFactory.getRule(this.legendre, n));
    }

    public GaussIntegrator legendre(int n, double d2, double d3) {
        return new GaussIntegrator(GaussIntegratorFactory.transform(GaussIntegratorFactory.getRule(this.legendre, n), d2, d3));
    }

    public GaussIntegrator legendreHighPrecision(int n) {
        return new GaussIntegrator(GaussIntegratorFactory.getRule(this.legendreHighPrecision, n));
    }

    public GaussIntegrator legendreHighPrecision(int n, double d2, double d3) {
        return new GaussIntegrator(GaussIntegratorFactory.transform(GaussIntegratorFactory.getRule(this.legendreHighPrecision, n), d2, d3));
    }

    public SymmetricGaussIntegrator hermite(int n) {
        return new SymmetricGaussIntegrator(GaussIntegratorFactory.getRule(this.hermite, n));
    }

    private static Pair<double[], double[]> getRule(BaseRuleFactory<? extends Number> baseRuleFactory, int n) {
        return baseRuleFactory.getRule(n);
    }

    private static Pair<double[], double[]> transform(Pair<double[], double[]> object, double d2, double d3) {
        double[] dArray = ((Pair)object).getFirst();
        object = ((Pair)object).getSecond();
        double d4 = (d3 - d2) / 2.0;
        double d5 = d2 + d4;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = dArray[n] * d4 + d5;
            Object object2 = object;
            int n2 = n++;
            object2[n2] = object2[n2] * d4;
        }
        return new Pair<double[], Object>(dArray, object);
    }
}

