/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays$OrderDirection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussIntegrator {
    private final double[] points;
    private final double[] weights;

    public GaussIntegrator(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        MathArrays.checkOrder(dArray, MathArrays$OrderDirection.INCREASING, true, true);
        this.points = (double[])dArray.clone();
        this.weights = (double[])dArray2.clone();
    }

    public GaussIntegrator(Pair<double[], double[]> pair) {
        this(pair.getFirst(), pair.getSecond());
    }

    public double integrate(UnivariateFunction univariateFunction) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            double d4 = this.points[i2];
            double d5 = this.weights[i2];
            double d6 = d5 * univariateFunction.value(d4) - d3;
            double d7 = d2 + d6;
            d3 = d7 - d2 - d6;
            d2 = d7;
        }
        return d2;
    }

    public int getNumberOfPoints() {
        return this.points.length;
    }

    public double getPoint(int n) {
        return this.points[n];
    }

    public double getWeight(int n) {
        return this.weights[n];
    }
}

