/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRuleFactory<T extends Number> {
    private final Map<Integer, Pair<T[], T[]>> pointsAndWeights = new TreeMap<Integer, Pair<T[], T[]>>();
    private final Map<Integer, Pair<double[], double[]>> pointsAndWeightsDouble = new TreeMap<Integer, Pair<double[], double[]>>();

    public Pair<double[], double[]> getRule(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, n);
        }
        Pair<Object[], Object[]> pair = this.pointsAndWeightsDouble.get(n);
        if (pair == null) {
            pair = this.getRuleInternal(n);
            pair = BaseRuleFactory.convertToDouble(pair);
            this.pointsAndWeightsDouble.put(n, pair);
        }
        return new Pair<Object, Object>(pair.getFirst().clone(), ((double[])pair.getSecond()).clone());
    }

    protected synchronized Pair<T[], T[]> getRuleInternal(int n) {
        Pair<T[], T[]> pair = this.pointsAndWeights.get(n);
        if (pair == null) {
            BaseRuleFactory baseRuleFactory = this;
            baseRuleFactory.addRule(baseRuleFactory.computeRule(n));
            return this.getRuleInternal(n);
        }
        return pair;
    }

    protected void addRule(Pair<T[], T[]> pair) {
        if (((Number[])pair.getFirst()).length != ((Number[])pair.getSecond()).length) {
            throw new DimensionMismatchException(((Number[])pair.getFirst()).length, ((Number[])pair.getSecond()).length);
        }
        this.pointsAndWeights.put(((Number[])pair.getFirst()).length, pair);
    }

    protected abstract Pair<T[], T[]> computeRule(int var1);

    private static <T extends Number> Pair<double[], double[]> convertToDouble(Pair<T[], T[]> numberArray) {
        Number[] numberArray2 = (Number[])numberArray.getFirst();
        numberArray = (Number[])numberArray.getSecond();
        int n = numberArray2.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = numberArray2[i2].doubleValue();
            dArray2[i2] = numberArray[i2].doubleValue();
        }
        return new Pair<double[], double[]>(dArray, dArray2);
    }
}

