/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class TrapezoidIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int TRAPEZOID_MAX_ITERATIONS_COUNT = 64;
    private double s;

    public TrapezoidIntegrator(double d2, double d3, int n, int n2) {
        super(d2, d3, n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public TrapezoidIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public TrapezoidIntegrator() {
        super(3, 64);
    }

    double stage(BaseAbstractUnivariateIntegrator baseAbstractUnivariateIntegrator, int n) {
        if (n == 0) {
            double d2 = baseAbstractUnivariateIntegrator.getMax();
            double d3 = baseAbstractUnivariateIntegrator.getMin();
            this.s = 0.5 * (d2 - d3) * (baseAbstractUnivariateIntegrator.computeObjectiveValue(d3) + baseAbstractUnivariateIntegrator.computeObjectiveValue(d2));
            return this.s;
        }
        long l = 1L << n - 1;
        double d4 = 0.0;
        double d5 = baseAbstractUnivariateIntegrator.getMax();
        double d6 = baseAbstractUnivariateIntegrator.getMin();
        double d7 = (d5 - d6) / (double)l;
        double d8 = d6 + d7 * 0.5;
        for (long i2 = 0L; i2 < l; ++i2) {
            d4 += baseAbstractUnivariateIntegrator.computeObjectiveValue(d8);
            d8 += d7;
        }
        this.s = 0.5 * (this.s + d4 * d7);
        return this.s;
    }

    protected double doIntegrate() {
        TrapezoidIntegrator trapezoidIntegrator = this;
        double d2 = trapezoidIntegrator.stage(trapezoidIntegrator, 0);
        this.incrementCount();
        while (true) {
            double d3;
            double d4;
            int n = this.getIterations();
            TrapezoidIntegrator trapezoidIntegrator2 = this;
            double d5 = trapezoidIntegrator2.stage(trapezoidIntegrator2, n);
            if (n >= this.getMinimalIterationCount() && ((d4 = FastMath.abs(d5 - d2)) <= (d3 = this.getRelativeAccuracy() * (FastMath.abs(d2) + FastMath.abs(d5)) * 0.5) || d4 <= this.getAbsoluteAccuracy())) {
                return d5;
            }
            d2 = d5;
            this.incrementCount();
        }
    }
}

