/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class SimpsonIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int SIMPSON_MAX_ITERATIONS_COUNT = 64;

    public SimpsonIntegrator(double d2, double d3, int n, int n2) {
        super(d2, d3, n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public SimpsonIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public SimpsonIntegrator() {
        super(3, 64);
    }

    protected double doIntegrate() {
        TrapezoidIntegrator trapezoidIntegrator = new TrapezoidIntegrator();
        if (this.getMinimalIterationCount() == 1) {
            return (4.0 * trapezoidIntegrator.stage(this, 1) - trapezoidIntegrator.stage(this, 0)) / 3.0;
        }
        double d2 = 0.0;
        double d3 = trapezoidIntegrator.stage(this, 0);
        while (true) {
            double d4;
            double d5;
            SimpsonIntegrator simpsonIntegrator = this;
            double d6 = trapezoidIntegrator.stage(simpsonIntegrator, simpsonIntegrator.getIterations());
            this.incrementCount();
            double d7 = (d6 * 4.0 - d3) / 3.0;
            if (this.getIterations() >= this.getMinimalIterationCount() && ((d5 = FastMath.abs(d7 - d2)) <= (d4 = this.getRelativeAccuracy() * (FastMath.abs(d2) + FastMath.abs(d7)) * 0.5) || d5 <= this.getAbsoluteAccuracy())) {
                return d7;
            }
            d2 = d7;
            d3 = d6;
        }
    }
}

