/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class RombergIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int ROMBERG_MAX_ITERATIONS_COUNT = 32;

    public RombergIntegrator(double d2, double d3, int n, int n2) {
        super(d2, d3, n, n2);
        if (n2 > 32) {
            throw new NumberIsTooLargeException(n2, (Number)32, false);
        }
    }

    public RombergIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 32) {
            throw new NumberIsTooLargeException(n2, (Number)32, false);
        }
    }

    public RombergIntegrator() {
        super(3, 32);
    }

    protected double doIntegrate() {
        int n = this.getMaximalIterationCount() + 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        TrapezoidIntegrator trapezoidIntegrator = new TrapezoidIntegrator();
        dArray2[0] = trapezoidIntegrator.stage(this, 0);
        this.incrementCount();
        double d2 = dArray2[0];
        while (true) {
            double d3;
            double d4;
            int n2 = this.getIterations();
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
            dArray3[0] = trapezoidIntegrator.stage(this, n2);
            this.incrementCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                double d5;
                double d6 = (1L << 2 * i2) - 1L;
                double d7 = d5 = dArray2[i2 - 1];
                dArray2[i2] = d7 + (d7 - dArray[i2 - 1]) / d6;
            }
            double d8 = dArray2[n2];
            if (n2 >= this.getMinimalIterationCount() && ((d4 = FastMath.abs(d8 - d2)) <= (d3 = this.getRelativeAccuracy() * (FastMath.abs(d2) + FastMath.abs(d8)) * 0.5) || d4 <= this.getAbsoluteAccuracy())) {
                return d8;
            }
            d2 = d8;
        }
    }
}

