/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class MidPointIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int MIDPOINT_MAX_ITERATIONS_COUNT = 64;

    public MidPointIntegrator(double d2, double d3, int n, int n2) {
        super(d2, d3, n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public MidPointIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public MidPointIntegrator() {
        super(3, 64);
    }

    private double stage(int n, double d2, double d3, double d4) {
        long l = 1L << n - 1;
        double d5 = 0.0;
        double d6 = d4 / (double)l;
        double d7 = d3 + d6 * 0.5;
        for (long i2 = 0L; i2 < l; ++i2) {
            d5 += this.computeObjectiveValue(d7);
            d7 += d6;
        }
        return 0.5 * (d2 + d5 * d6);
    }

    protected double doIntegrate() {
        double d2 = this.getMin();
        double d3 = this.getMax() - d2;
        double d4 = d2 + d3 * 0.5;
        double d5 = d3 * this.computeObjectiveValue(d4);
        while (true) {
            double d6;
            double d7;
            this.incrementCount();
            int n = this.getIterations();
            double d8 = this.stage(n, d5, d2, d3);
            if (n >= this.getMinimalIterationCount() && ((d7 = FastMath.abs(d8 - d5)) <= (d6 = this.getRelativeAccuracy() * (FastMath.abs(d5) + FastMath.abs(d8)) * 0.5) || d7 <= this.getAbsoluteAccuracy())) {
                return d8;
            }
            d5 = d8;
        }
    }
}

