/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.IterativeLegendreGaussIntegrator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.integration.gauss.GaussIntegratorFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class IterativeLegendreGaussIntegrator
extends BaseAbstractUnivariateIntegrator {
    private static final GaussIntegratorFactory FACTORY = new GaussIntegratorFactory();
    private final int numberOfPoints;

    public IterativeLegendreGaussIntegrator(int n, double d2, double d3, int n2, int n3) {
        super(d2, d3, n2, n3);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, n);
        }
        this.numberOfPoints = n;
    }

    public IterativeLegendreGaussIntegrator(int n, double d2, double d3) {
        this(n, d2, d3, 3, Integer.MAX_VALUE);
    }

    public IterativeLegendreGaussIntegrator(int n, int n2, int n3) {
        this(n, 1.0E-6, 1.0E-15, n2, n3);
    }

    protected double doIntegrate() {
        double d2 = this.stage(1);
        int n = 2;
        while (true) {
            double d3 = this.stage(n);
            double d4 = FastMath.abs(d3 - d2);
            double d5 = FastMath.max(this.getAbsoluteAccuracy(), this.getRelativeAccuracy() * (FastMath.abs(d2) + FastMath.abs(d3)) * 0.5);
            if (this.getIterations() + 1 >= this.getMinimalIterationCount() && d4 <= d5) {
                return d3;
            }
            double d6 = FastMath.min(4.0, FastMath.pow(d4 / d5, 0.5 / (double)this.numberOfPoints));
            n = FastMath.max((int)(d6 * (double)n), n + 1);
            d2 = d3;
            this.incrementCount();
        }
    }

    private double stage(int n) {
        IterativeLegendreGaussIntegrator$1 iterativeLegendreGaussIntegrator$1 = new IterativeLegendreGaussIntegrator$1(this);
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = (d3 - d2) / (double)n;
        double d5 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            double d6 = d2 + (double)i2 * d4;
            double d7 = d6 + d4;
            GaussIntegrator gaussIntegrator = FACTORY.legendreHighPrecision(this.numberOfPoints, d6, d7);
            d5 += gaussIntegrator.integrate(iterativeLegendreGaussIntegrator$1);
        }
        return d5;
    }
}

