/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Arrays;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException();
        }
        if (dArray2.length != dArray.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        MathArrays.checkOrder(dArray);
        this.abscissa = MathArrays.copyOf(dArray);
        this.ordinate = MathArrays.copyOf(dArray2);
    }

    public double value(double d2) {
        int n = Arrays.binarySearch(this.abscissa, d2);
        double d3 = n < -1 ? this.ordinate[-n - 2] : (n >= 0 ? this.ordinate[n] : this.ordinate[0]);
        return d3;
    }
}

