/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class Sinc
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private static final double SHORTCUT = 0.006;
    private final boolean normalized;

    public Sinc() {
        this(false);
    }

    public Sinc(boolean bl) {
        this.normalized = bl;
    }

    public double value(double d2) {
        double d3;
        double d4 = d3 = this.normalized ? d2 * Math.PI : d2;
        if (FastMath.abs(d4) <= 0.006) {
            double d5 = d3;
            double d6 = d5 * d5;
            return ((d6 - 20.0) * d6 + 120.0) / 120.0;
        }
        return FastMath.sin(d3) / d3;
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d2 = (this.normalized ? Math.PI : 1.0) * derivativeStructure.getValue();
        double d3 = d2 * d2;
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        if (FastMath.abs(d2) <= 0.006) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                int n = i2 / 2;
                dArray[i2] = (i2 & 1) == 0 ? (double)((n & 1) == 0 ? 1 : -1) * (1.0 / (double)(i2 + 1) - d3 * (1.0 / (double)(2 * i2 + 6) - d3 / (double)(i2 * 24 + 120))) : ((n & 1) == 0 ? -d2 : d2) * (1.0 / (double)(i2 + 2) - d3 * (1.0 / (double)(i2 * 6 + 24) - d3 / (double)(i2 * 120 + 720)));
            }
        } else {
            double d4 = 1.0 / d2;
            double d5 = FastMath.cos(d2);
            double d6 = FastMath.sin(d2);
            dArray[0] = d4 * d6;
            double[] dArray2 = new double[dArray.length];
            double[] dArray3 = dArray2;
            dArray2[0] = 1.0;
            double d7 = d4;
            for (int i3 = 1; i3 < dArray.length; ++i3) {
                int n;
                double d8 = 0.0;
                double d9 = 0.0;
                if ((i3 & 1) == 0) {
                    dArray3[i3] = 0.0;
                    n = i3;
                } else {
                    dArray3[i3] = dArray3[i3 - 1];
                    d9 = dArray3[i3];
                    n = i3 - 1;
                }
                while (n > 1) {
                    int n2 = n;
                    dArray3[n2] = (double)(n2 - i3) * dArray3[n] - dArray3[n - 1];
                    d8 = d8 * d3 + dArray3[n];
                    dArray3[n - 1] = (double)(n - 1 - i3) * dArray3[n - 1] + dArray3[n - 2];
                    d9 = d9 * d3 + dArray3[n - 1];
                    n -= 2;
                }
                dArray3[0] = dArray3[0] * (double)(-i3);
                d8 = d8 * d3 + dArray3[0];
                dArray[i3] = (d7 *= d4) * (d8 * d6 + d9 * d2 * d5);
            }
        }
        if (this.normalized) {
            double d10 = Math.PI;
            int n = 1;
            while (n < dArray.length) {
                int n3 = n++;
                dArray[n3] = dArray[n3] * d10;
                d10 *= Math.PI;
            }
        }
        return derivativeStructure.compose(dArray);
    }
}

