/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Arrays;

public class Sigmoid
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private final double lo;
    private final double hi;

    public Sigmoid() {
        this(0.0, 1.0);
    }

    public Sigmoid(double d2, double d3) {
        this.lo = d2;
        this.hi = d3;
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    public double value(double d2) {
        return Sigmoid.value(d2, this.lo, this.hi);
    }

    private static double value(double d2, double d3, double d4) {
        return d3 + (d4 - d3) / (1.0 + FastMath.exp(-d2));
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double d2 = FastMath.exp(-derivativeStructure.getValue());
        if (Double.isInfinite(d2)) {
            dArray[0] = this.lo;
            Arrays.fill(dArray, 1, dArray.length, 0.0);
        } else {
            double[] dArray2 = new double[dArray.length];
            double d3 = 1.0 / (d2 + 1.0);
            double d4 = this.hi - this.lo;
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d5 = 0.0;
                dArray2[i2] = 1.0;
                for (int i3 = i2; i3 >= 0; --i3) {
                    d5 = d5 * d2 + dArray2[i3];
                    if (i3 > 1) {
                        dArray2[i3 - 1] = (double)(i2 - i3 + 2) * dArray2[i3 - 2] - (double)(i3 - 1) * dArray2[i3 - 1];
                        continue;
                    }
                    dArray2[0] = 0.0;
                }
                dArray[i2] = (d4 *= d3) * d5;
            }
            dArray[0] = dArray[0] + this.lo;
        }
        return derivativeStructure.compose(dArray);
    }

    static /* synthetic */ double access$000(double d2, double d3, double d4) {
        return Sigmoid.value(d2, d3, d4);
    }
}

