/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class Logit
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private final double lo;
    private final double hi;

    public Logit() {
        this(0.0, 1.0);
    }

    public Logit(double d2, double d3) {
        this.lo = d2;
        this.hi = d3;
    }

    public double value(double d2) {
        return Logit.value(d2, this.lo, this.hi);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double d2, double d3, double d4) {
        if (d2 < d3 || d2 > d4) {
            throw new OutOfRangeException(d2, (Number)d3, d4);
        }
        return FastMath.log((d2 - d3) / (d4 - d2));
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d2 = derivativeStructure.getValue();
        if (d2 < this.lo || d2 > this.hi) {
            throw new OutOfRangeException(d2, (Number)this.lo, this.hi);
        }
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double[] dArray2 = dArray;
        dArray[0] = FastMath.log((d2 - this.lo) / (this.hi - d2));
        if (Double.isInfinite(dArray2[0])) {
            if (dArray2.length > 1) {
                dArray2[1] = Double.POSITIVE_INFINITY;
            }
            for (int i2 = 2; i2 < dArray2.length; ++i2) {
                dArray2[i2] = dArray2[i2 - 2];
            }
        } else {
            double d3;
            double d4;
            double d5 = d4 = 1.0 / (d2 - this.lo);
            double d6 = d3 = 1.0 / (this.hi - d2);
            for (int i3 = 1; i3 < dArray2.length; ++i3) {
                dArray2[i3] = d5 + d6;
                d5 *= (double)(-i3) * d4;
                d6 *= (double)i3 * d3;
            }
        }
        return derivativeStructure.compose(dArray2);
    }

    static /* synthetic */ double access$000(double d2, double d3, double d4) {
        return Logit.value(d2, d3, d4);
    }
}

