/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class Logistic
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private final double a;
    private final double k;
    private final double b;
    private final double oneOverN;
    private final double q;
    private final double m;

    public Logistic(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d7 <= 0.0) {
            throw new NotStrictlyPositiveException(d7);
        }
        this.k = d2;
        this.m = d3;
        this.b = d4;
        this.q = d5;
        this.a = d6;
        this.oneOverN = 1.0 / d7;
    }

    public double value(double d2) {
        return Logistic.value(this.m - d2, this.k, this.b, this.q, this.a, this.oneOverN);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double d2, double d3, double d4, double d5, double d6, double d7) {
        return d6 + (d3 - d6) / FastMath.pow(1.0 + d5 * FastMath.exp(d4 * d2), d7);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        return derivativeStructure.negate().add(this.m).multiply(this.b).exp().multiply(this.q).add(1.0).pow(this.oneOverN).reciprocal().multiply(this.k - this.a).add(this.a);
    }

    static /* synthetic */ double access$000(double d2, double d3, double d4, double d5, double d6, double d7) {
        return Logistic.value(d2, d3, d4, d5, d6, d7);
    }
}

