/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class HarmonicOscillator
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private final double amplitude;
    private final double omega;
    private final double phase;

    public HarmonicOscillator(double d2, double d3, double d4) {
        this.amplitude = d2;
        this.omega = d3;
        this.phase = d4;
    }

    public double value(double d2) {
        return HarmonicOscillator.value(this.omega * d2 + this.phase, this.amplitude);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double d2, double d3) {
        return d3 * FastMath.cos(d2);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d2 = derivativeStructure.getValue();
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double d3 = this.omega * d2 + this.phase;
        dArray[0] = this.amplitude * FastMath.cos(d3);
        if (dArray.length > 1) {
            dArray[1] = -this.amplitude * this.omega * FastMath.sin(d3);
            double d4 = -this.omega * this.omega;
            for (int i2 = 2; i2 < dArray.length; ++i2) {
                dArray[i2] = d4 * dArray[i2 - 2];
            }
        }
        return derivativeStructure.compose(dArray);
    }

    static /* synthetic */ double access$000(double d2, double d3) {
        return HarmonicOscillator.value(d2, d3);
    }
}

