/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.Arrays;

public class Gaussian
implements DifferentiableUnivariateFunction,
UnivariateDifferentiableFunction {
    private final double mean;
    private final double is;
    private final double i2s2;
    private final double norm;

    public Gaussian(double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new NotStrictlyPositiveException(d4);
        }
        this.norm = d2;
        this.mean = d3;
        this.is = 1.0 / d4;
        this.i2s2 = 0.5 * this.is * this.is;
    }

    public Gaussian(double d2, double d3) {
        this(1.0 / (d3 * FastMath.sqrt(Math.PI * 2)), d2, d3);
    }

    public Gaussian() {
        this(0.0, 1.0);
    }

    public double value(double d2) {
        return Gaussian.value(d2 - this.mean, this.norm, this.i2s2);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double d2, double d3, double d4) {
        return d3 * FastMath.exp(-d2 * d2 * d4);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d2;
        double d3 = this.is * (derivativeStructure.getValue() - this.mean);
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = dArray2;
        dArray2[0] = 1.0;
        double d4 = d3;
        double d5 = d4 * d4;
        double d6 = this.norm * FastMath.exp(d5 * -0.5);
        if (d2 <= Precision.SAFE_MIN) {
            Arrays.fill(dArray, 0.0);
        } else {
            dArray[0] = d6;
            for (int i2 = 1; i2 < dArray.length; ++i2) {
                double d7 = 0.0;
                dArray3[i2] = -dArray3[i2 - 1];
                for (int i3 = i2; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d5 + dArray3[i3];
                    if (i3 > 2) {
                        dArray3[i3 - 2] = (double)(i3 - 1) * dArray3[i3 - 1] - dArray3[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray3[0] = dArray3[1];
                }
                if ((i2 & 1) == 1) {
                    d7 *= d3;
                }
                dArray[i2] = (d6 *= this.is) * d7;
            }
        }
        return derivativeStructure.compose(dArray);
    }

    static /* synthetic */ double access$000(double d2, double d3, double d4) {
        return Gaussian.value(d2, d3, d4);
    }
}

