/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.ParametricUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Gaussian;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;

public class Gaussian$Parametric
implements ParametricUnivariateFunction {
    public double value(double d2, double ... dArray) {
        this.validateParameters(dArray);
        double d3 = d2 - dArray[1];
        double d4 = 1.0 / (2.0 * dArray[2] * dArray[2]);
        return Gaussian.access$000(d3, dArray[0], d4);
    }

    public double[] gradient(double d2, double ... dArray) {
        this.validateParameters(dArray);
        double d3 = dArray[0];
        double d4 = d2 - dArray[1];
        double d5 = dArray[2];
        double d6 = 1.0 / (d5 * 2.0 * d5);
        double d7 = Gaussian.access$000(d4, 1.0, d6);
        double d8 = d3 * d7 * 2.0 * d6 * d4;
        double d9 = d8 * d4 / d5;
        return new double[]{d7, d8, d9};
    }

    private void validateParameters(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length != 3) {
            throw new DimensionMismatchException(dArray.length, 3);
        }
        if (dArray[2] <= 0.0) {
            throw new NotStrictlyPositiveException(dArray[2]);
        }
    }
}

